@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VolumeQuotaRule].
 */
@PulumiTagMarker
public class VolumeQuotaRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeQuotaRuleArgs = VolumeQuotaRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeQuotaRuleArgsBuilder.() -> Unit) {
        val builder = VolumeQuotaRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VolumeQuotaRule {
        val builtJavaResource = com.pulumi.azurenative.netapp.VolumeQuotaRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VolumeQuotaRule(builtJavaResource)
    }
}

/**
 * Quota Rule of a Volume
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01, 2023-07-01-preview, 2023-11-01.
 * ## Example Usage
 * ### VolumeQuotaRules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeQuotaRule = new AzureNative.NetApp.VolumeQuotaRule("volumeQuotaRule", new()
 *     {
 *         AccountName = "account-9957",
 *         Location = "westus",
 *         PoolName = "pool-5210",
 *         QuotaSizeInKiBs = 100005,
 *         QuotaTarget = "1821",
 *         QuotaType = AzureNative.NetApp.Type.IndividualUserQuota,
 *         ResourceGroupName = "myRG",
 *         VolumeName = "volume-6387",
 *         VolumeQuotaRuleName = "rule-0004",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewVolumeQuotaRule(ctx, "volumeQuotaRule", &netapp.VolumeQuotaRuleArgs{
 * 			AccountName:         pulumi.String("account-9957"),
 * 			Location:            pulumi.String("westus"),
 * 			PoolName:            pulumi.String("pool-5210"),
 * 			QuotaSizeInKiBs:     pulumi.Float64(100005),
 * 			QuotaTarget:         pulumi.String("1821"),
 * 			QuotaType:           pulumi.String(netapp.TypeIndividualUserQuota),
 * 			ResourceGroupName:   pulumi.String("myRG"),
 * 			VolumeName:          pulumi.String("volume-6387"),
 * 			VolumeQuotaRuleName: pulumi.String("rule-0004"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.VolumeQuotaRule;
 * import com.pulumi.azurenative.netapp.VolumeQuotaRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeQuotaRule = new VolumeQuotaRule("volumeQuotaRule", VolumeQuotaRuleArgs.builder()
 *             .accountName("account-9957")
 *             .location("westus")
 *             .poolName("pool-5210")
 *             .quotaSizeInKiBs(100005)
 *             .quotaTarget("1821")
 *             .quotaType("IndividualUserQuota")
 *             .resourceGroupName("myRG")
 *             .volumeName("volume-6387")
 *             .volumeQuotaRuleName("rule-0004")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:VolumeQuotaRule account-9957/pool-5210/volume-6387/rule-0004 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/volumeQuotaRules/{volumeQuotaRuleName}
 * ```
 */
public class VolumeQuotaRule internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.VolumeQuotaRule,
) : KotlinCustomResource(javaResource, VolumeQuotaRuleMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the status of the VolumeQuotaRule at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Size of quota
     */
    public val quotaSizeInKiBs: Output<Double>?
        get() = javaResource.quotaSizeInKiBs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by running <wmic useraccount where name='user-name' get sid>
     */
    public val quotaTarget: Output<String>?
        get() = javaResource.quotaTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of quota
     */
    public val quotaType: Output<String>?
        get() = javaResource.quotaType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VolumeQuotaRuleMapper : ResourceMapper<VolumeQuotaRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.VolumeQuotaRule::class == javaResource::class

    override fun map(javaResource: Resource): VolumeQuotaRule = VolumeQuotaRule(
        javaResource as
            com.pulumi.azurenative.netapp.VolumeQuotaRule,
    )
}

/**
 * @see [VolumeQuotaRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VolumeQuotaRule].
 */
public suspend fun volumeQuotaRule(
    name: String,
    block: suspend VolumeQuotaRuleResourceBuilder.() -> Unit,
): VolumeQuotaRule {
    val builder = VolumeQuotaRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VolumeQuotaRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volumeQuotaRule(name: String): VolumeQuotaRule {
    val builder = VolumeQuotaRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
