@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
 */
public enum class AvsDataStore(
    public val javaValue: com.pulumi.azurenative.netapp.enums.AvsDataStore,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.AvsDataStore> {
    /**
     * avsDataStore is enabled
     */
    Enabled(com.pulumi.azurenative.netapp.enums.AvsDataStore.Enabled),

    /**
     * avsDataStore is disabled
     */
    Disabled(com.pulumi.azurenative.netapp.enums.AvsDataStore.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.AvsDataStore = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.AvsDataStore): AvsDataStore =
            AvsDataStore.values().first { it.javaValue == javaType }
    }
}
