@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value can only be set when creating new pool.
 */
public enum class EncryptionType(
    public val javaValue: com.pulumi.azurenative.netapp.enums.EncryptionType,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.EncryptionType> {
    /**
     * EncryptionType Single, volumes will use single encryption at rest
     */
    Single(com.pulumi.azurenative.netapp.enums.EncryptionType.Single),

    /**
     * EncryptionType Double, volumes will use double encryption at rest
     */
    Double(com.pulumi.azurenative.netapp.enums.EncryptionType.Double),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.EncryptionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.EncryptionType): EncryptionType = EncryptionType.values().first { it.javaValue == javaType }
    }
}
