@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Basic network, or Standard features available to the volume.
 */
public enum class NetworkFeatures(
    public val javaValue: com.pulumi.azurenative.netapp.enums.NetworkFeatures,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.NetworkFeatures> {
    /**
     * Basic network feature.
     */
    Basic(com.pulumi.azurenative.netapp.enums.NetworkFeatures.Basic),

    /**
     * Standard network feature.
     */
    Standard(com.pulumi.azurenative.netapp.enums.NetworkFeatures.Standard),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.NetworkFeatures = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.NetworkFeatures): NetworkFeatures = NetworkFeatures.values().first { it.javaValue == javaType }
    }
}
