@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
 */
public enum class SecurityStyle(
    public val javaValue: com.pulumi.azurenative.netapp.enums.SecurityStyle,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.SecurityStyle> {
    Ntfs(com.pulumi.azurenative.netapp.enums.SecurityStyle.Ntfs),
    Unix(com.pulumi.azurenative.netapp.enums.SecurityStyle.Unix),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.SecurityStyle = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.SecurityStyle): SecurityStyle = SecurityStyle.values().first { it.javaValue == javaType }
    }
}
