@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
 */
public enum class SmbAccessBasedEnumeration(
    public val javaValue: com.pulumi.azurenative.netapp.enums.SmbAccessBasedEnumeration,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.SmbAccessBasedEnumeration> {
    /**
     * smbAccessBasedEnumeration share setting is disabled
     */
    Disabled(com.pulumi.azurenative.netapp.enums.SmbAccessBasedEnumeration.Disabled),

    /**
     * smbAccessBasedEnumeration share setting is enabled
     */
    Enabled(com.pulumi.azurenative.netapp.enums.SmbAccessBasedEnumeration.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.SmbAccessBasedEnumeration = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.SmbAccessBasedEnumeration): SmbAccessBasedEnumeration =
            SmbAccessBasedEnumeration.values().first { it.javaValue == javaType }
    }
}
