@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
 */
public enum class SmbNonBrowsable(
    public val javaValue: com.pulumi.azurenative.netapp.enums.SmbNonBrowsable,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.SmbNonBrowsable> {
    /**
     * smbNonBrowsable share setting is disabled
     */
    Disabled(com.pulumi.azurenative.netapp.enums.SmbNonBrowsable.Disabled),

    /**
     * smbNonBrowsable share setting is enabled
     */
    Enabled(com.pulumi.azurenative.netapp.enums.SmbNonBrowsable.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.SmbNonBrowsable = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.SmbNonBrowsable): SmbNonBrowsable = SmbNonBrowsable.values().first { it.javaValue == javaType }
    }
}
