@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.AccountEncryptionArgs.builder
import com.pulumi.azurenative.netapp.kotlin.enums.KeySource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Encryption settings
 * @property identity Identity used to authenticate to KeyVault. Applicable if keySource is 'Microsoft.KeyVault'.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp, Microsoft.KeyVault
 * @property keyVaultProperties Properties provided by KeVault. Applicable if keySource is 'Microsoft.KeyVault'.
 */
public data class AccountEncryptionArgs(
    public val identity: Output<EncryptionIdentityArgs>? = null,
    public val keySource: Output<Either<String, KeySource>>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.AccountEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.AccountEncryptionArgs =
        com.pulumi.azurenative.netapp.inputs.AccountEncryptionArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keySource(
                keySource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AccountEncryptionArgs].
 */
@PulumiTagMarker
public class AccountEncryptionArgsBuilder internal constructor() {
    private var identity: Output<EncryptionIdentityArgs>? = null

    private var keySource: Output<Either<String, KeySource>>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    /**
     * @param value Identity used to authenticate to KeyVault. Applicable if keySource is 'Microsoft.KeyVault'.
     */
    @JvmName("lejysrgvlcuvtmyl")
    public suspend fun identity(`value`: Output<EncryptionIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp, Microsoft.KeyVault
     */
    @JvmName("lyvmaselyeytgwha")
    public suspend fun keySource(`value`: Output<Either<String, KeySource>>) {
        this.keySource = value
    }

    /**
     * @param value Properties provided by KeVault. Applicable if keySource is 'Microsoft.KeyVault'.
     */
    @JvmName("skiiksntnoffxdxt")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Identity used to authenticate to KeyVault. Applicable if keySource is 'Microsoft.KeyVault'.
     */
    @JvmName("tsuqohnjvxqvubgs")
    public suspend fun identity(`value`: EncryptionIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity used to authenticate to KeyVault. Applicable if keySource is 'Microsoft.KeyVault'.
     */
    @JvmName("yatsaftufygaodcw")
    public suspend fun identity(argument: suspend EncryptionIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp, Microsoft.KeyVault
     */
    @JvmName("eidfwbgbuuxkjsqe")
    public suspend fun keySource(`value`: Either<String, KeySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp, Microsoft.KeyVault
     */
    @JvmName("ddmdnueyyajybmgl")
    public fun keySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp, Microsoft.KeyVault
     */
    @JvmName("oscflufolxsnspex")
    public fun keySource(`value`: KeySource) {
        val toBeMapped = Either.ofRight<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Properties provided by KeVault. Applicable if keySource is 'Microsoft.KeyVault'.
     */
    @JvmName("rrlkdpwmxrugjmuq")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties provided by KeVault. Applicable if keySource is 'Microsoft.KeyVault'.
     */
    @JvmName("mwptxmmashnopayn")
    public suspend fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    internal fun build(): AccountEncryptionArgs = AccountEncryptionArgs(
        identity = identity,
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
    )
}
