@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.ExportPolicyRuleArgs.builder
import com.pulumi.azurenative.netapp.kotlin.enums.ChownMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Volume Export Policy Rule
 * @property allowedClients Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
 * @property chownMode This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
 * @property cifs Allows CIFS protocol
 * @property hasRootAccess Has root access to volume
 * @property kerberos5ReadOnly Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5ReadWrite Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5iReadOnly Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5iReadWrite Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5pReadOnly Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5pReadWrite Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
 * @property nfsv3 Allows NFSv3 protocol. Enable only for NFSv3 type volumes
 * @property nfsv41 Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
 * @property ruleIndex Order index
 * @property unixReadOnly Read only access
 * @property unixReadWrite Read and write access
 */
public data class ExportPolicyRuleArgs(
    public val allowedClients: Output<String>? = null,
    public val chownMode: Output<Either<String, ChownMode>>? = null,
    public val cifs: Output<Boolean>? = null,
    public val hasRootAccess: Output<Boolean>? = null,
    public val kerberos5ReadOnly: Output<Boolean>? = null,
    public val kerberos5ReadWrite: Output<Boolean>? = null,
    public val kerberos5iReadOnly: Output<Boolean>? = null,
    public val kerberos5iReadWrite: Output<Boolean>? = null,
    public val kerberos5pReadOnly: Output<Boolean>? = null,
    public val kerberos5pReadWrite: Output<Boolean>? = null,
    public val nfsv3: Output<Boolean>? = null,
    public val nfsv41: Output<Boolean>? = null,
    public val ruleIndex: Output<Int>? = null,
    public val unixReadOnly: Output<Boolean>? = null,
    public val unixReadWrite: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.ExportPolicyRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.ExportPolicyRuleArgs =
        com.pulumi.azurenative.netapp.inputs.ExportPolicyRuleArgs.builder()
            .allowedClients(allowedClients?.applyValue({ args0 -> args0 }))
            .chownMode(
                chownMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cifs(cifs?.applyValue({ args0 -> args0 }))
            .hasRootAccess(hasRootAccess?.applyValue({ args0 -> args0 }))
            .kerberos5ReadOnly(kerberos5ReadOnly?.applyValue({ args0 -> args0 }))
            .kerberos5ReadWrite(kerberos5ReadWrite?.applyValue({ args0 -> args0 }))
            .kerberos5iReadOnly(kerberos5iReadOnly?.applyValue({ args0 -> args0 }))
            .kerberos5iReadWrite(kerberos5iReadWrite?.applyValue({ args0 -> args0 }))
            .kerberos5pReadOnly(kerberos5pReadOnly?.applyValue({ args0 -> args0 }))
            .kerberos5pReadWrite(kerberos5pReadWrite?.applyValue({ args0 -> args0 }))
            .nfsv3(nfsv3?.applyValue({ args0 -> args0 }))
            .nfsv41(nfsv41?.applyValue({ args0 -> args0 }))
            .ruleIndex(ruleIndex?.applyValue({ args0 -> args0 }))
            .unixReadOnly(unixReadOnly?.applyValue({ args0 -> args0 }))
            .unixReadWrite(unixReadWrite?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportPolicyRuleArgs].
 */
@PulumiTagMarker
public class ExportPolicyRuleArgsBuilder internal constructor() {
    private var allowedClients: Output<String>? = null

    private var chownMode: Output<Either<String, ChownMode>>? = null

    private var cifs: Output<Boolean>? = null

    private var hasRootAccess: Output<Boolean>? = null

    private var kerberos5ReadOnly: Output<Boolean>? = null

    private var kerberos5ReadWrite: Output<Boolean>? = null

    private var kerberos5iReadOnly: Output<Boolean>? = null

    private var kerberos5iReadWrite: Output<Boolean>? = null

    private var kerberos5pReadOnly: Output<Boolean>? = null

    private var kerberos5pReadWrite: Output<Boolean>? = null

    private var nfsv3: Output<Boolean>? = null

    private var nfsv41: Output<Boolean>? = null

    private var ruleIndex: Output<Int>? = null

    private var unixReadOnly: Output<Boolean>? = null

    private var unixReadWrite: Output<Boolean>? = null

    /**
     * @param value Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
     */
    @JvmName("giwosbslpsjahvqb")
    public suspend fun allowedClients(`value`: Output<String>) {
        this.allowedClients = value
    }

    /**
     * @param value This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
     */
    @JvmName("efqvkjwcqsmuvivh")
    public suspend fun chownMode(`value`: Output<Either<String, ChownMode>>) {
        this.chownMode = value
    }

    /**
     * @param value Allows CIFS protocol
     */
    @JvmName("nryyktalbcpanxwa")
    public suspend fun cifs(`value`: Output<Boolean>) {
        this.cifs = value
    }

    /**
     * @param value Has root access to volume
     */
    @JvmName("ojqyxaemsqpnlnha")
    public suspend fun hasRootAccess(`value`: Output<Boolean>) {
        this.hasRootAccess = value
    }

    /**
     * @param value Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("nmkppnlggnacdjfi")
    public suspend fun kerberos5ReadOnly(`value`: Output<Boolean>) {
        this.kerberos5ReadOnly = value
    }

    /**
     * @param value Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("exsgxcdbjqyaryep")
    public suspend fun kerberos5ReadWrite(`value`: Output<Boolean>) {
        this.kerberos5ReadWrite = value
    }

    /**
     * @param value Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("nfxoqkbhviysjdku")
    public suspend fun kerberos5iReadOnly(`value`: Output<Boolean>) {
        this.kerberos5iReadOnly = value
    }

    /**
     * @param value Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("yeedfhafnvueuprd")
    public suspend fun kerberos5iReadWrite(`value`: Output<Boolean>) {
        this.kerberos5iReadWrite = value
    }

    /**
     * @param value Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("umsefnfjysghppnl")
    public suspend fun kerberos5pReadOnly(`value`: Output<Boolean>) {
        this.kerberos5pReadOnly = value
    }

    /**
     * @param value Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("xhpnxppccxforqhp")
    public suspend fun kerberos5pReadWrite(`value`: Output<Boolean>) {
        this.kerberos5pReadWrite = value
    }

    /**
     * @param value Allows NFSv3 protocol. Enable only for NFSv3 type volumes
     */
    @JvmName("pmwdrygirkqoknib")
    public suspend fun nfsv3(`value`: Output<Boolean>) {
        this.nfsv3 = value
    }

    /**
     * @param value Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
     */
    @JvmName("tdvoaxrnqhewtuns")
    public suspend fun nfsv41(`value`: Output<Boolean>) {
        this.nfsv41 = value
    }

    /**
     * @param value Order index
     */
    @JvmName("shtsqugfxefvkjcm")
    public suspend fun ruleIndex(`value`: Output<Int>) {
        this.ruleIndex = value
    }

    /**
     * @param value Read only access
     */
    @JvmName("tngifaalmfdrnccs")
    public suspend fun unixReadOnly(`value`: Output<Boolean>) {
        this.unixReadOnly = value
    }

    /**
     * @param value Read and write access
     */
    @JvmName("xlmliijmupnsfjdo")
    public suspend fun unixReadWrite(`value`: Output<Boolean>) {
        this.unixReadWrite = value
    }

    /**
     * @param value Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
     */
    @JvmName("hwwtldanhoqgjtwr")
    public suspend fun allowedClients(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedClients = mapped
    }

    /**
     * @param value This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
     */
    @JvmName("xgkcyvbvbxlpjybj")
    public suspend fun chownMode(`value`: Either<String, ChownMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chownMode = mapped
    }

    /**
     * @param value This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
     */
    @JvmName("yflwpburshummxcr")
    public fun chownMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChownMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.chownMode = mapped
    }

    /**
     * @param value This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
     */
    @JvmName("bwewtchqhmpdllkq")
    public fun chownMode(`value`: ChownMode) {
        val toBeMapped = Either.ofRight<String, ChownMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.chownMode = mapped
    }

    /**
     * @param value Allows CIFS protocol
     */
    @JvmName("nktpuydeuibdylwc")
    public suspend fun cifs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cifs = mapped
    }

    /**
     * @param value Has root access to volume
     */
    @JvmName("udkcfxfhcbklvkwt")
    public suspend fun hasRootAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasRootAccess = mapped
    }

    /**
     * @param value Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("reqglodmjxokisqi")
    public suspend fun kerberos5ReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberos5ReadOnly = mapped
    }

    /**
     * @param value Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("eadhvylrqjdkumjp")
    public suspend fun kerberos5ReadWrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberos5ReadWrite = mapped
    }

    /**
     * @param value Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("iyrwewjtmmhqaomh")
    public suspend fun kerberos5iReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberos5iReadOnly = mapped
    }

    /**
     * @param value Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("ioccwqgmvppgauku")
    public suspend fun kerberos5iReadWrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberos5iReadWrite = mapped
    }

    /**
     * @param value Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("bumkcwacbevqmpgj")
    public suspend fun kerberos5pReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberos5pReadOnly = mapped
    }

    /**
     * @param value Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("otiyhyfokvihcsmq")
    public suspend fun kerberos5pReadWrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberos5pReadWrite = mapped
    }

    /**
     * @param value Allows NFSv3 protocol. Enable only for NFSv3 type volumes
     */
    @JvmName("brskjgywavpojvqn")
    public suspend fun nfsv3(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsv3 = mapped
    }

    /**
     * @param value Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
     */
    @JvmName("ornkkgqwhxyiikxh")
    public suspend fun nfsv41(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsv41 = mapped
    }

    /**
     * @param value Order index
     */
    @JvmName("cxredmomyukbiieq")
    public suspend fun ruleIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleIndex = mapped
    }

    /**
     * @param value Read only access
     */
    @JvmName("exundeckowefbapt")
    public suspend fun unixReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unixReadOnly = mapped
    }

    /**
     * @param value Read and write access
     */
    @JvmName("iwfaigauyprywvxp")
    public suspend fun unixReadWrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unixReadWrite = mapped
    }

    internal fun build(): ExportPolicyRuleArgs = ExportPolicyRuleArgs(
        allowedClients = allowedClients,
        chownMode = chownMode,
        cifs = cifs,
        hasRootAccess = hasRootAccess,
        kerberos5ReadOnly = kerberos5ReadOnly,
        kerberos5ReadWrite = kerberos5ReadWrite,
        kerberos5iReadOnly = kerberos5iReadOnly,
        kerberos5iReadWrite = kerberos5iReadWrite,
        kerberos5pReadOnly = kerberos5pReadOnly,
        kerberos5pReadWrite = kerberos5pReadWrite,
        nfsv3 = nfsv3,
        nfsv41 = nfsv41,
        ruleIndex = ruleIndex,
        unixReadOnly = unixReadOnly,
        unixReadWrite = unixReadWrite,
    )
}
