@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.GetBackupVaultPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property backupVaultName The name of the Backup Vault
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBackupVaultPlainArgs(
    public val accountName: String,
    public val backupVaultName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.GetBackupVaultPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.GetBackupVaultPlainArgs =
        com.pulumi.azurenative.netapp.inputs.GetBackupVaultPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .backupVaultName(backupVaultName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupVaultPlainArgs].
 */
@PulumiTagMarker
public class GetBackupVaultPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var backupVaultName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("kpueidffbnddfiis")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Backup Vault
     */
    @JvmName("onkonjybvxfbecnh")
    public suspend fun backupVaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backupVaultName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rjqvyxpppapacjhu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBackupVaultPlainArgs = GetBackupVaultPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        backupVaultName = backupVaultName ?: throw PulumiNullFieldException("backupVaultName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
