@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.GetVolumeQuotaRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property poolName The name of the capacity pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeName The name of the volume
 * @property volumeQuotaRuleName The name of volume quota rule
 */
public data class GetVolumeQuotaRulePlainArgs(
    public val accountName: String,
    public val poolName: String,
    public val resourceGroupName: String,
    public val volumeName: String,
    public val volumeQuotaRuleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.GetVolumeQuotaRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.GetVolumeQuotaRulePlainArgs =
        com.pulumi.azurenative.netapp.inputs.GetVolumeQuotaRulePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeName(volumeName.let({ args0 -> args0 }))
            .volumeQuotaRuleName(volumeQuotaRuleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumeQuotaRulePlainArgs].
 */
@PulumiTagMarker
public class GetVolumeQuotaRulePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var poolName: String? = null

    private var resourceGroupName: String? = null

    private var volumeName: String? = null

    private var volumeQuotaRuleName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("yvcgcuqkdjjsllkj")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("ilfsjvjsfjnovxij")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dmveuhocxrdrycsg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("odofefeiyapbdvdk")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeName = mapped
    }

    /**
     * @param value The name of volume quota rule
     */
    @JvmName("cijsoctymcdymgyq")
    public suspend fun volumeQuotaRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeQuotaRuleName = mapped
    }

    internal fun build(): GetVolumeQuotaRulePlainArgs = GetVolumeQuotaRulePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
        volumeQuotaRuleName = volumeQuotaRuleName ?: throw PulumiNullFieldException("volumeQuotaRuleName"),
    )
}
