@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.HourlyScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Hourly Schedule properties
 * @property minute Indicates which minute snapshot should be taken
 * @property snapshotsToKeep Hourly snapshot count to keep
 * @property usedBytes Resource size in bytes, current storage usage for the volume in bytes
 */
public data class HourlyScheduleArgs(
    public val minute: Output<Int>? = null,
    public val snapshotsToKeep: Output<Int>? = null,
    public val usedBytes: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.HourlyScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.HourlyScheduleArgs =
        com.pulumi.azurenative.netapp.inputs.HourlyScheduleArgs.builder()
            .minute(minute?.applyValue({ args0 -> args0 }))
            .snapshotsToKeep(snapshotsToKeep?.applyValue({ args0 -> args0 }))
            .usedBytes(usedBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HourlyScheduleArgs].
 */
@PulumiTagMarker
public class HourlyScheduleArgsBuilder internal constructor() {
    private var minute: Output<Int>? = null

    private var snapshotsToKeep: Output<Int>? = null

    private var usedBytes: Output<Double>? = null

    /**
     * @param value Indicates which minute snapshot should be taken
     */
    @JvmName("mbmpdjxrjvmoigwe")
    public suspend fun minute(`value`: Output<Int>) {
        this.minute = value
    }

    /**
     * @param value Hourly snapshot count to keep
     */
    @JvmName("ytpicwdouuycfmsq")
    public suspend fun snapshotsToKeep(`value`: Output<Int>) {
        this.snapshotsToKeep = value
    }

    /**
     * @param value Resource size in bytes, current storage usage for the volume in bytes
     */
    @JvmName("cebkjkdfxuclqooy")
    public suspend fun usedBytes(`value`: Output<Double>) {
        this.usedBytes = value
    }

    /**
     * @param value Indicates which minute snapshot should be taken
     */
    @JvmName("pftqlxbqgbonfkgg")
    public suspend fun minute(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minute = mapped
    }

    /**
     * @param value Hourly snapshot count to keep
     */
    @JvmName("yfvioepnwyxysxmi")
    public suspend fun snapshotsToKeep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotsToKeep = mapped
    }

    /**
     * @param value Resource size in bytes, current storage usage for the volume in bytes
     */
    @JvmName("vfkkcusxlntknoaq")
    public suspend fun usedBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedBytes = mapped
    }

    internal fun build(): HourlyScheduleArgs = HourlyScheduleArgs(
        minute = minute,
        snapshotsToKeep = snapshotsToKeep,
        usedBytes = usedBytes,
    )
}
