@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of key vault.
 * @property keyName The name of KeyVault key.
 * @property keyVaultResourceId The resource ID of KeyVault.
 * @property keyVaultUri The Uri of KeyVault.
 */
public data class KeyVaultPropertiesArgs(
    public val keyName: Output<String>,
    public val keyVaultResourceId: Output<String>,
    public val keyVaultUri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.netapp.inputs.KeyVaultPropertiesArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVaultResourceId(keyVaultResourceId.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultResourceId: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("ipdrfvbhpcvrebud")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The resource ID of KeyVault.
     */
    @JvmName("vwurfsnynywgdqsb")
    public suspend fun keyVaultResourceId(`value`: Output<String>) {
        this.keyVaultResourceId = value
    }

    /**
     * @param value The Uri of KeyVault.
     */
    @JvmName("kclahaamuwknqfag")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("ksbfsxoribabifap")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The resource ID of KeyVault.
     */
    @JvmName("xkxfxmkxiufexnrt")
    public suspend fun keyVaultResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultResourceId = mapped
    }

    /**
     * @param value The Uri of KeyVault.
     */
    @JvmName("vbuqfgnahfnwfdeg")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVaultResourceId = keyVaultResourceId ?: throw PulumiNullFieldException("keyVaultResourceId"),
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
    )
}
