@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.ListVolumeReplicationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property poolName The name of the capacity pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeName The name of the volume
 */
public data class ListVolumeReplicationsPlainArgs(
    public val accountName: String,
    public val poolName: String,
    public val resourceGroupName: String,
    public val volumeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.ListVolumeReplicationsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.ListVolumeReplicationsPlainArgs =
        com.pulumi.azurenative.netapp.inputs.ListVolumeReplicationsPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeName(volumeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListVolumeReplicationsPlainArgs].
 */
@PulumiTagMarker
public class ListVolumeReplicationsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var poolName: String? = null

    private var resourceGroupName: String? = null

    private var volumeName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("fesghmpyiwprlciy")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("gjgbkraqgafkqhly")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jlsjosufdisfevsn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("tftaqpkqrebiyuit")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeName = mapped
    }

    internal fun build(): ListVolumeReplicationsPlainArgs = ListVolumeReplicationsPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
