@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.ReplicationObjectArgs.builder
import com.pulumi.azurenative.netapp.kotlin.enums.EndpointType
import com.pulumi.azurenative.netapp.kotlin.enums.ReplicationSchedule
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Replication properties
 * @property endpointType Indicates whether the local volume is the source or destination for the Volume Replication
 * @property remoteVolumeRegion The remote region for the other end of the Volume Replication.
 * @property remoteVolumeResourceId The resource ID of the remote volume.
 * @property replicationId Id
 * @property replicationSchedule Schedule
 */
public data class ReplicationObjectArgs(
    public val endpointType: Output<Either<String, EndpointType>>? = null,
    public val remoteVolumeRegion: Output<String>? = null,
    public val remoteVolumeResourceId: Output<String>,
    public val replicationId: Output<String>? = null,
    public val replicationSchedule: Output<Either<String, ReplicationSchedule>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.ReplicationObjectArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.ReplicationObjectArgs =
        com.pulumi.azurenative.netapp.inputs.ReplicationObjectArgs.builder()
            .endpointType(
                endpointType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .remoteVolumeRegion(remoteVolumeRegion?.applyValue({ args0 -> args0 }))
            .remoteVolumeResourceId(remoteVolumeResourceId.applyValue({ args0 -> args0 }))
            .replicationId(replicationId?.applyValue({ args0 -> args0 }))
            .replicationSchedule(
                replicationSchedule?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ReplicationObjectArgs].
 */
@PulumiTagMarker
public class ReplicationObjectArgsBuilder internal constructor() {
    private var endpointType: Output<Either<String, EndpointType>>? = null

    private var remoteVolumeRegion: Output<String>? = null

    private var remoteVolumeResourceId: Output<String>? = null

    private var replicationId: Output<String>? = null

    private var replicationSchedule: Output<Either<String, ReplicationSchedule>>? = null

    /**
     * @param value Indicates whether the local volume is the source or destination for the Volume Replication
     */
    @JvmName("unmfsolaedjmsdvv")
    public suspend fun endpointType(`value`: Output<Either<String, EndpointType>>) {
        this.endpointType = value
    }

    /**
     * @param value The remote region for the other end of the Volume Replication.
     */
    @JvmName("sblmxuhijvttblos")
    public suspend fun remoteVolumeRegion(`value`: Output<String>) {
        this.remoteVolumeRegion = value
    }

    /**
     * @param value The resource ID of the remote volume.
     */
    @JvmName("mdrgdkdcljnyhldw")
    public suspend fun remoteVolumeResourceId(`value`: Output<String>) {
        this.remoteVolumeResourceId = value
    }

    /**
     * @param value Id
     */
    @JvmName("kmuqchxqyygrypem")
    public suspend fun replicationId(`value`: Output<String>) {
        this.replicationId = value
    }

    /**
     * @param value Schedule
     */
    @JvmName("icwppirxiijgdyoi")
    public suspend fun replicationSchedule(`value`: Output<Either<String, ReplicationSchedule>>) {
        this.replicationSchedule = value
    }

    /**
     * @param value Indicates whether the local volume is the source or destination for the Volume Replication
     */
    @JvmName("aqhdqvulehirdhlk")
    public suspend fun endpointType(`value`: Either<String, EndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Indicates whether the local volume is the source or destination for the Volume Replication
     */
    @JvmName("jcmtsjvyjijlwdmc")
    public fun endpointType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Indicates whether the local volume is the source or destination for the Volume Replication
     */
    @JvmName("ncvxwrbgndlsswum")
    public fun endpointType(`value`: EndpointType) {
        val toBeMapped = Either.ofRight<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The remote region for the other end of the Volume Replication.
     */
    @JvmName("twumhsbnmbvboojl")
    public suspend fun remoteVolumeRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVolumeRegion = mapped
    }

    /**
     * @param value The resource ID of the remote volume.
     */
    @JvmName("uqjjchvqskjhlpvs")
    public suspend fun remoteVolumeResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteVolumeResourceId = mapped
    }

    /**
     * @param value Id
     */
    @JvmName("clyvnckbopnnmqgm")
    public suspend fun replicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationId = mapped
    }

    /**
     * @param value Schedule
     */
    @JvmName("jumwlrixncbalyop")
    public suspend fun replicationSchedule(`value`: Either<String, ReplicationSchedule>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSchedule = mapped
    }

    /**
     * @param value Schedule
     */
    @JvmName("aixcgmymghupkxih")
    public fun replicationSchedule(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationSchedule>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationSchedule = mapped
    }

    /**
     * @param value Schedule
     */
    @JvmName("mauktlqiiikglntu")
    public fun replicationSchedule(`value`: ReplicationSchedule) {
        val toBeMapped = Either.ofRight<String, ReplicationSchedule>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationSchedule = mapped
    }

    internal fun build(): ReplicationObjectArgs = ReplicationObjectArgs(
        endpointType = endpointType,
        remoteVolumeRegion = remoteVolumeRegion,
        remoteVolumeResourceId = remoteVolumeResourceId ?: throw
            PulumiNullFieldException("remoteVolumeResourceId"),
        replicationId = replicationId,
        replicationSchedule = replicationSchedule,
    )
}
