@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.VolumePropertiesDataProtectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DataProtection type volumes include an object containing details of the replication
 * @property backup Backup Properties
 * @property replication Replication properties
 * @property snapshot Snapshot properties.
 * @property volumeRelocation VolumeRelocation properties
 */
public data class VolumePropertiesDataProtectionArgs(
    public val backup: Output<VolumeBackupPropertiesArgs>? = null,
    public val replication: Output<ReplicationObjectArgs>? = null,
    public val snapshot: Output<VolumeSnapshotPropertiesArgs>? = null,
    public val volumeRelocation: Output<VolumeRelocationPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.VolumePropertiesDataProtectionArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.VolumePropertiesDataProtectionArgs =
        com.pulumi.azurenative.netapp.inputs.VolumePropertiesDataProtectionArgs.builder()
            .backup(backup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replication(replication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snapshot(snapshot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeRelocation(
                volumeRelocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VolumePropertiesDataProtectionArgs].
 */
@PulumiTagMarker
public class VolumePropertiesDataProtectionArgsBuilder internal constructor() {
    private var backup: Output<VolumeBackupPropertiesArgs>? = null

    private var replication: Output<ReplicationObjectArgs>? = null

    private var snapshot: Output<VolumeSnapshotPropertiesArgs>? = null

    private var volumeRelocation: Output<VolumeRelocationPropertiesArgs>? = null

    /**
     * @param value Backup Properties
     */
    @JvmName("wforcusgbehrfigc")
    public suspend fun backup(`value`: Output<VolumeBackupPropertiesArgs>) {
        this.backup = value
    }

    /**
     * @param value Replication properties
     */
    @JvmName("lboosewueauuexpp")
    public suspend fun replication(`value`: Output<ReplicationObjectArgs>) {
        this.replication = value
    }

    /**
     * @param value Snapshot properties.
     */
    @JvmName("ovvaqbbwxosxrfsa")
    public suspend fun snapshot(`value`: Output<VolumeSnapshotPropertiesArgs>) {
        this.snapshot = value
    }

    /**
     * @param value VolumeRelocation properties
     */
    @JvmName("aqjglcvygfbxxemt")
    public suspend fun volumeRelocation(`value`: Output<VolumeRelocationPropertiesArgs>) {
        this.volumeRelocation = value
    }

    /**
     * @param value Backup Properties
     */
    @JvmName("ahvadpfcxequkjwd")
    public suspend fun backup(`value`: VolumeBackupPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backup = mapped
    }

    /**
     * @param argument Backup Properties
     */
    @JvmName("gnuulhxklrsmwrdj")
    public suspend fun backup(argument: suspend VolumeBackupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeBackupPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backup = mapped
    }

    /**
     * @param value Replication properties
     */
    @JvmName("qamaldwoxgwwtqax")
    public suspend fun replication(`value`: ReplicationObjectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replication = mapped
    }

    /**
     * @param argument Replication properties
     */
    @JvmName("bqxyxdluodckbmml")
    public suspend fun replication(argument: suspend ReplicationObjectArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicationObjectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.replication = mapped
    }

    /**
     * @param value Snapshot properties.
     */
    @JvmName("cvujtgbmcqlyglrv")
    public suspend fun snapshot(`value`: VolumeSnapshotPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshot = mapped
    }

    /**
     * @param argument Snapshot properties.
     */
    @JvmName("rikviuxyxlrudcpr")
    public suspend fun snapshot(argument: suspend VolumeSnapshotPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeSnapshotPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snapshot = mapped
    }

    /**
     * @param value VolumeRelocation properties
     */
    @JvmName("jiaucftfkrnqshyj")
    public suspend fun volumeRelocation(`value`: VolumeRelocationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeRelocation = mapped
    }

    /**
     * @param argument VolumeRelocation properties
     */
    @JvmName("xhbcteurfgkscjvx")
    public suspend fun volumeRelocation(argument: suspend VolumeRelocationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeRelocationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.volumeRelocation = mapped
    }

    internal fun build(): VolumePropertiesDataProtectionArgs = VolumePropertiesDataProtectionArgs(
        backup = backup,
        replication = replication,
        snapshot = snapshot,
        volumeRelocation = volumeRelocation,
    )
}
