@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.VolumeSnapshotPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Volume Snapshot Properties
 * @property snapshotPolicyId Snapshot Policy ResourceId
 */
public data class VolumeSnapshotPropertiesArgs(
    public val snapshotPolicyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.VolumeSnapshotPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.VolumeSnapshotPropertiesArgs =
        com.pulumi.azurenative.netapp.inputs.VolumeSnapshotPropertiesArgs.builder()
            .snapshotPolicyId(snapshotPolicyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeSnapshotPropertiesArgs].
 */
@PulumiTagMarker
public class VolumeSnapshotPropertiesArgsBuilder internal constructor() {
    private var snapshotPolicyId: Output<String>? = null

    /**
     * @param value Snapshot Policy ResourceId
     */
    @JvmName("trspfuwimsoumjmx")
    public suspend fun snapshotPolicyId(`value`: Output<String>) {
        this.snapshotPolicyId = value
    }

    /**
     * @param value Snapshot Policy ResourceId
     */
    @JvmName("xyytnkmloucrvfrf")
    public suspend fun snapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotPolicyId = mapped
    }

    internal fun build(): VolumeSnapshotPropertiesArgs = VolumeSnapshotPropertiesArgs(
        snapshotPolicyId = snapshotPolicyId,
    )
}
