@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.WeeklyScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Weekly Schedule properties, make a snapshot every week at a specific day or days
 * @property day Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day names in english
 * @property hour Indicates which hour in UTC timezone a snapshot should be taken
 * @property minute Indicates which minute snapshot should be taken
 * @property snapshotsToKeep Weekly snapshot count to keep
 * @property usedBytes Resource size in bytes, current storage usage for the volume in bytes
 */
public data class WeeklyScheduleArgs(
    public val day: Output<String>? = null,
    public val hour: Output<Int>? = null,
    public val minute: Output<Int>? = null,
    public val snapshotsToKeep: Output<Int>? = null,
    public val usedBytes: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.WeeklyScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.WeeklyScheduleArgs =
        com.pulumi.azurenative.netapp.inputs.WeeklyScheduleArgs.builder()
            .day(day?.applyValue({ args0 -> args0 }))
            .hour(hour?.applyValue({ args0 -> args0 }))
            .minute(minute?.applyValue({ args0 -> args0 }))
            .snapshotsToKeep(snapshotsToKeep?.applyValue({ args0 -> args0 }))
            .usedBytes(usedBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WeeklyScheduleArgs].
 */
@PulumiTagMarker
public class WeeklyScheduleArgsBuilder internal constructor() {
    private var day: Output<String>? = null

    private var hour: Output<Int>? = null

    private var minute: Output<Int>? = null

    private var snapshotsToKeep: Output<Int>? = null

    private var usedBytes: Output<Double>? = null

    /**
     * @param value Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day names in english
     */
    @JvmName("npsxsolhsdqyqeyl")
    public suspend fun day(`value`: Output<String>) {
        this.day = value
    }

    /**
     * @param value Indicates which hour in UTC timezone a snapshot should be taken
     */
    @JvmName("uqndugnoefxjgkce")
    public suspend fun hour(`value`: Output<Int>) {
        this.hour = value
    }

    /**
     * @param value Indicates which minute snapshot should be taken
     */
    @JvmName("npuuwgjwhfvgjuss")
    public suspend fun minute(`value`: Output<Int>) {
        this.minute = value
    }

    /**
     * @param value Weekly snapshot count to keep
     */
    @JvmName("himjmsurojdoauju")
    public suspend fun snapshotsToKeep(`value`: Output<Int>) {
        this.snapshotsToKeep = value
    }

    /**
     * @param value Resource size in bytes, current storage usage for the volume in bytes
     */
    @JvmName("oqfonvsnsdlubqwh")
    public suspend fun usedBytes(`value`: Output<Double>) {
        this.usedBytes = value
    }

    /**
     * @param value Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day names in english
     */
    @JvmName("uhgsuhxsjkdiaaai")
    public suspend fun day(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value Indicates which hour in UTC timezone a snapshot should be taken
     */
    @JvmName("bgxftghrmeyhinek")
    public suspend fun hour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hour = mapped
    }

    /**
     * @param value Indicates which minute snapshot should be taken
     */
    @JvmName("bvbaquumcpaqtxse")
    public suspend fun minute(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minute = mapped
    }

    /**
     * @param value Weekly snapshot count to keep
     */
    @JvmName("pclsyuqcbwrrgiau")
    public suspend fun snapshotsToKeep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotsToKeep = mapped
    }

    /**
     * @param value Resource size in bytes, current storage usage for the volume in bytes
     */
    @JvmName("vrisfluswmatxrnn")
    public suspend fun usedBytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedBytes = mapped
    }

    internal fun build(): WeeklyScheduleArgs = WeeklyScheduleArgs(
        day = day,
        hour = hour,
        minute = minute,
        snapshotsToKeep = snapshotsToKeep,
        usedBytes = usedBytes,
    )
}
