@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Daily Schedule properties
 * @property hour Indicates which hour in UTC timezone a snapshot should be taken
 * @property minute Indicates which minute snapshot should be taken
 * @property snapshotsToKeep Daily snapshot count to keep
 * @property usedBytes Resource size in bytes, current storage usage for the volume in bytes
 */
public data class DailyScheduleResponse(
    public val hour: Int? = null,
    public val minute: Int? = null,
    public val snapshotsToKeep: Int? = null,
    public val usedBytes: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.DailyScheduleResponse): DailyScheduleResponse = DailyScheduleResponse(
            hour = javaType.hour().map({ args0 -> args0 }).orElse(null),
            minute = javaType.minute().map({ args0 -> args0 }).orElse(null),
            snapshotsToKeep = javaType.snapshotsToKeep().map({ args0 -> args0 }).orElse(null),
            usedBytes = javaType.usedBytes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
