@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity used to authenticate with key vault.
 * @property principalId The principal ID (object ID) of the identity used to authenticate with key vault. Read-only.
 * @property userAssignedIdentity The ARM resource identifier of the user assigned identity used to authenticate with key vault. Applicable if identity.type has 'UserAssigned'. It should match key of identity.userAssignedIdentities.
 */
public data class EncryptionIdentityResponse(
    public val principalId: String,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.EncryptionIdentityResponse): EncryptionIdentityResponse = EncryptionIdentityResponse(
            principalId = javaType.principalId(),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
