@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Volume Export Policy Rule
 * @property allowedClients Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
 * @property chownMode This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
 * @property cifs Allows CIFS protocol
 * @property hasRootAccess Has root access to volume
 * @property kerberos5ReadOnly Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5ReadWrite Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5iReadOnly Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5iReadWrite Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5pReadOnly Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
 * @property kerberos5pReadWrite Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
 * @property nfsv3 Allows NFSv3 protocol. Enable only for NFSv3 type volumes
 * @property nfsv41 Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
 * @property ruleIndex Order index
 * @property unixReadOnly Read only access
 * @property unixReadWrite Read and write access
 */
public data class ExportPolicyRuleResponse(
    public val allowedClients: String? = null,
    public val chownMode: String? = null,
    public val cifs: Boolean? = null,
    public val hasRootAccess: Boolean? = null,
    public val kerberos5ReadOnly: Boolean? = null,
    public val kerberos5ReadWrite: Boolean? = null,
    public val kerberos5iReadOnly: Boolean? = null,
    public val kerberos5iReadWrite: Boolean? = null,
    public val kerberos5pReadOnly: Boolean? = null,
    public val kerberos5pReadWrite: Boolean? = null,
    public val nfsv3: Boolean? = null,
    public val nfsv41: Boolean? = null,
    public val ruleIndex: Int? = null,
    public val unixReadOnly: Boolean? = null,
    public val unixReadWrite: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.ExportPolicyRuleResponse): ExportPolicyRuleResponse = ExportPolicyRuleResponse(
            allowedClients = javaType.allowedClients().map({ args0 -> args0 }).orElse(null),
            chownMode = javaType.chownMode().map({ args0 -> args0 }).orElse(null),
            cifs = javaType.cifs().map({ args0 -> args0 }).orElse(null),
            hasRootAccess = javaType.hasRootAccess().map({ args0 -> args0 }).orElse(null),
            kerberos5ReadOnly = javaType.kerberos5ReadOnly().map({ args0 -> args0 }).orElse(null),
            kerberos5ReadWrite = javaType.kerberos5ReadWrite().map({ args0 -> args0 }).orElse(null),
            kerberos5iReadOnly = javaType.kerberos5iReadOnly().map({ args0 -> args0 }).orElse(null),
            kerberos5iReadWrite = javaType.kerberos5iReadWrite().map({ args0 -> args0 }).orElse(null),
            kerberos5pReadOnly = javaType.kerberos5pReadOnly().map({ args0 -> args0 }).orElse(null),
            kerberos5pReadWrite = javaType.kerberos5pReadWrite().map({ args0 -> args0 }).orElse(null),
            nfsv3 = javaType.nfsv3().map({ args0 -> args0 }).orElse(null),
            nfsv41 = javaType.nfsv41().map({ args0 -> args0 }).orElse(null),
            ruleIndex = javaType.ruleIndex().map({ args0 -> args0 }).orElse(null),
            unixReadOnly = javaType.unixReadOnly().map({ args0 -> args0 }).orElse(null),
            unixReadWrite = javaType.unixReadWrite().map({ args0 -> args0 }).orElse(null),
        )
    }
}
