@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Result of the post subvolume and action is to get metadata of the subvolume.
 * @property accessedTimeStamp Most recent access time and date
 * @property bytesUsed Bytes used
 * @property changedTimeStamp Most recent change time and date
 * @property creationTimeStamp Creation time and date
 * @property id Resource Id
 * @property modifiedTimeStamp Most recent modification time and date
 * @property name Resource name
 * @property parentPath Path to the parent subvolume
 * @property path Path to the subvolume
 * @property permissions Permissions of the subvolume
 * @property provisioningState Azure lifecycle management
 * @property size Size of subvolume
 * @property type Resource type
 */
public data class GetSubvolumeMetadataResult(
    public val accessedTimeStamp: String? = null,
    public val bytesUsed: Double? = null,
    public val changedTimeStamp: String? = null,
    public val creationTimeStamp: String? = null,
    public val id: String,
    public val modifiedTimeStamp: String? = null,
    public val name: String,
    public val parentPath: String? = null,
    public val path: String? = null,
    public val permissions: String? = null,
    public val provisioningState: String? = null,
    public val size: Double? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetSubvolumeMetadataResult): GetSubvolumeMetadataResult = GetSubvolumeMetadataResult(
            accessedTimeStamp = javaType.accessedTimeStamp().map({ args0 -> args0 }).orElse(null),
            bytesUsed = javaType.bytesUsed().map({ args0 -> args0 }).orElse(null),
            changedTimeStamp = javaType.changedTimeStamp().map({ args0 -> args0 }).orElse(null),
            creationTimeStamp = javaType.creationTimeStamp().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            modifiedTimeStamp = javaType.modifiedTimeStamp().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parentPath = javaType.parentPath().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            permissions = javaType.permissions().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
