@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Hourly Schedule properties
 * @property minute Indicates which minute snapshot should be taken
 * @property snapshotsToKeep Hourly snapshot count to keep
 * @property usedBytes Resource size in bytes, current storage usage for the volume in bytes
 */
public data class HourlyScheduleResponse(
    public val minute: Int? = null,
    public val snapshotsToKeep: Int? = null,
    public val usedBytes: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.HourlyScheduleResponse): HourlyScheduleResponse = HourlyScheduleResponse(
            minute = javaType.minute().map({ args0 -> args0 }).orElse(null),
            snapshotsToKeep = javaType.snapshotsToKeep().map({ args0 -> args0 }).orElse(null),
            usedBytes = javaType.usedBytes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
