@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Mount target properties
 * @property fileSystemId UUID v4 used to identify the MountTarget
 * @property ipAddress The mount target's IPv4 address
 * @property mountTargetId UUID v4 used to identify the MountTarget
 * @property smbServerFqdn The SMB server's Fully Qualified Domain Name, FQDN
 */
public data class MountTargetPropertiesResponse(
    public val fileSystemId: String,
    public val ipAddress: String,
    public val mountTargetId: String,
    public val smbServerFqdn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.MountTargetPropertiesResponse): MountTargetPropertiesResponse = MountTargetPropertiesResponse(
            fileSystemId = javaType.fileSystemId(),
            ipAddress = javaType.ipAddress(),
            mountTargetId = javaType.mountTargetId(),
            smbServerFqdn = javaType.smbServerFqdn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
