@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Volume Backup Properties
 * @property backupEnabled Backup Enabled
 * @property backupPolicyId Backup Policy Resource ID
 * @property policyEnforced Policy Enforced
 */
public data class VolumeBackupPropertiesResponse(
    public val backupEnabled: Boolean? = null,
    public val backupPolicyId: String? = null,
    public val policyEnforced: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.VolumeBackupPropertiesResponse): VolumeBackupPropertiesResponse = VolumeBackupPropertiesResponse(
            backupEnabled = javaType.backupEnabled().map({ args0 -> args0 }).orElse(null),
            backupPolicyId = javaType.backupPolicyId().map({ args0 -> args0 }).orElse(null),
            policyEnforced = javaType.policyEnforced().map({ args0 -> args0 }).orElse(null),
        )
    }
}
