@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Volume details using the backup policy
 * @property backupsCount Total count of backups for volume
 * @property policyEnabled Policy enabled
 * @property volumeName Volume name
 */
public data class VolumeBackupsResponse(
    public val backupsCount: Int? = null,
    public val policyEnabled: Boolean? = null,
    public val volumeName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.VolumeBackupsResponse): VolumeBackupsResponse = VolumeBackupsResponse(
            backupsCount = javaType.backupsCount().map({ args0 -> args0 }).orElse(null),
            policyEnabled = javaType.policyEnabled().map({ args0 -> args0 }).orElse(null),
            volumeName = javaType.volumeName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
