@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Volume group properties
 * @property applicationIdentifier Application specific identifier
 * @property applicationType Application Type
 * @property deploymentSpecId Application specific identifier of deployment rules for the volume group
 * @property globalPlacementRules Application specific placement rules for the volume group
 * @property groupDescription Group Description
 * @property volumesCount Number of volumes in volume group
 */
public data class VolumeGroupMetaDataResponse(
    public val applicationIdentifier: String? = null,
    public val applicationType: String? = null,
    public val deploymentSpecId: String? = null,
    public val globalPlacementRules: List<PlacementKeyValuePairsResponse>? = null,
    public val groupDescription: String? = null,
    public val volumesCount: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.VolumeGroupMetaDataResponse): VolumeGroupMetaDataResponse = VolumeGroupMetaDataResponse(
            applicationIdentifier = javaType.applicationIdentifier().map({ args0 -> args0 }).orElse(null),
            applicationType = javaType.applicationType().map({ args0 -> args0 }).orElse(null),
            deploymentSpecId = javaType.deploymentSpecId().map({ args0 -> args0 }).orElse(null),
            globalPlacementRules = javaType.globalPlacementRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.PlacementKeyValuePairsResponse.Companion.toKotlin(args0)
                })
            }),
            groupDescription = javaType.groupDescription().map({ args0 -> args0 }).orElse(null),
            volumesCount = javaType.volumesCount(),
        )
    }
}
