@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Suppress

/**
 * DataProtection type volumes include an object containing details of the replication
 * @property backup Backup Properties
 * @property replication Replication properties
 * @property snapshot Snapshot properties.
 * @property volumeRelocation VolumeRelocation properties
 */
public data class VolumePropertiesResponseDataProtection(
    public val backup: VolumeBackupPropertiesResponse? = null,
    public val replication: ReplicationObjectResponse? = null,
    public val snapshot: VolumeSnapshotPropertiesResponse? = null,
    public val volumeRelocation: VolumeRelocationPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.VolumePropertiesResponseDataProtection): VolumePropertiesResponseDataProtection = VolumePropertiesResponseDataProtection(
            backup = javaType.backup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.VolumeBackupPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            replication = javaType.replication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.ReplicationObjectResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snapshot = javaType.snapshot().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.VolumeSnapshotPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            volumeRelocation = javaType.volumeRelocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.VolumeRelocationPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
