@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Volume relocation properties
 * @property readyToBeFinalized Has relocation finished and is ready to be cleaned up
 * @property relocationRequested Has relocation been requested for this volume
 */
public data class VolumeRelocationPropertiesResponse(
    public val readyToBeFinalized: Boolean,
    public val relocationRequested: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.VolumeRelocationPropertiesResponse): VolumeRelocationPropertiesResponse = VolumeRelocationPropertiesResponse(
            readyToBeFinalized = javaType.readyToBeFinalized(),
            relocationRequested = javaType.relocationRequested().map({ args0 -> args0 }).orElse(null),
        )
    }
}
