@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Private Endpoint connection on an application gateway.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Update Application Gateway Private Endpoint Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationGatewayPrivateEndpointConnection = new AzureNative.Network.ApplicationGatewayPrivateEndpointConnection("applicationGatewayPrivateEndpointConnection", new()
 *     {
 *         ApplicationGatewayName = "appgw",
 *         ConnectionName = "connection1",
 *         Name = "connection1",
 *         PrivateLinkServiceConnectionState = new AzureNative.Network.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "approved it for some reason.",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewApplicationGatewayPrivateEndpointConnection(ctx, "applicationGatewayPrivateEndpointConnection", &network.ApplicationGatewayPrivateEndpointConnectionArgs{
 * 			ApplicationGatewayName: pulumi.String("appgw"),
 * 			ConnectionName:         pulumi.String("connection1"),
 * 			Name:                   pulumi.String("connection1"),
 * 			PrivateLinkServiceConnectionState: &network.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("approved it for some reason."),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnection;
 * import com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationGatewayPrivateEndpointConnection = new ApplicationGatewayPrivateEndpointConnection("applicationGatewayPrivateEndpointConnection", ApplicationGatewayPrivateEndpointConnectionArgs.builder()
 *             .applicationGatewayName("appgw")
 *             .connectionName("connection1")
 *             .name("connection1")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("approved it for some reason.")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ApplicationGatewayPrivateEndpointConnection testPlePeConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/privateEndpointConnections/{connectionName}
 * ```
 * @property applicationGatewayName The name of the application gateway.
 * @property connectionName The name of the application gateway private endpoint connection.
 * @property id Resource ID.
 * @property name Name of the private endpoint connection on an application gateway.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The name of the resource group.
 */
public data class ApplicationGatewayPrivateEndpointConnectionArgs(
    public val applicationGatewayName: Output<String>? = null,
    public val connectionName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnectionArgs =
        com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnectionArgs.builder()
            .applicationGatewayName(applicationGatewayName?.applyValue({ args0 -> args0 }))
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayPrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayPrivateEndpointConnectionArgsBuilder internal constructor() {
    private var applicationGatewayName: Output<String>? = null

    private var connectionName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the application gateway.
     */
    @JvmName("emdhwxqyvjjrmqkr")
    public suspend fun applicationGatewayName(`value`: Output<String>) {
        this.applicationGatewayName = value
    }

    /**
     * @param value The name of the application gateway private endpoint connection.
     */
    @JvmName("tihpxhketvbxxggb")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("okrhtskhtllnwuka")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the private endpoint connection on an application gateway.
     */
    @JvmName("pjjyoeexxsvhdcnh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("bncpxypvikqalwcm")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("psxrdjlhqaluwjwi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the application gateway.
     */
    @JvmName("udhutdttjwgapvvt")
    public suspend fun applicationGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayName = mapped
    }

    /**
     * @param value The name of the application gateway private endpoint connection.
     */
    @JvmName("dbusutjytdrwgtuh")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fwhpaemimvgcdsmv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the private endpoint connection on an application gateway.
     */
    @JvmName("cecvpqdtdicnsqex")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("hfqkphyojjltwlrw")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("vfwclqnvqyqqsdlx")
    public suspend fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uxbmnqavbpnfirnj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ApplicationGatewayPrivateEndpointConnectionArgs =
        ApplicationGatewayPrivateEndpointConnectionArgs(
            applicationGatewayName = applicationGatewayName,
            connectionName = connectionName,
            id = id,
            name = name,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            resourceGroupName = resourceGroupName,
        )
}
