@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ConnectionMonitorArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorDestinationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorDestinationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorEndpointArgs
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorEndpointArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorOutputArgs
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorOutputArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorSourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorSourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorTestConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorTestConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorTestGroupArgs
import com.pulumi.azurenative.network.kotlin.inputs.ConnectionMonitorTestGroupArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about the connection monitor.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-09-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create connection monitor V1
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionMonitor = new AzureNative.Network.ConnectionMonitor("connectionMonitor", new()
 *     {
 *         ConnectionMonitorName = "cm1",
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Name = "source",
 *                 ResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/ct1",
 *             },
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Address = "bing.com",
 *                 Name = "destination",
 *             },
 *         },
 *         Location = "eastus",
 *         NetworkWatcherName = "nw1",
 *         ResourceGroupName = "rg1",
 *         TestConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorTestConfigurationArgs
 *             {
 *                 Name = "tcp",
 *                 Protocol = AzureNative.Network.ConnectionMonitorTestConfigurationProtocol.Tcp,
 *                 TcpConfiguration = new AzureNative.Network.Inputs.ConnectionMonitorTcpConfigurationArgs
 *                 {
 *                     Port = 80,
 *                 },
 *                 TestFrequencySec = 60,
 *             },
 *         },
 *         TestGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorTestGroupArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "destination",
 *                 },
 *                 Name = "tg",
 *                 Sources = new[]
 *                 {
 *                     "source",
 *                 },
 *                 TestConfigurations = new[]
 *                 {
 *                     "tcp",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewConnectionMonitor(ctx, "connectionMonitor", &network.ConnectionMonitorArgs{
 * 			ConnectionMonitorName: pulumi.String("cm1"),
 * 			Endpoints: network.ConnectionMonitorEndpointArray{
 * 				&network.ConnectionMonitorEndpointArgs{
 * 					Name:       pulumi.String("source"),
 * 					ResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/ct1"),
 * 				},
 * 				&network.ConnectionMonitorEndpointArgs{
 * 					Address: pulumi.String("bing.com"),
 * 					Name:    pulumi.String("destination"),
 * 				},
 * 			},
 * 			Location:           pulumi.String("eastus"),
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			TestConfigurations: network.ConnectionMonitorTestConfigurationArray{
 * 				&network.ConnectionMonitorTestConfigurationArgs{
 * 					Name:     pulumi.String("tcp"),
 * 					Protocol: pulumi.String(network.ConnectionMonitorTestConfigurationProtocolTcp),
 * 					TcpConfiguration: &network.ConnectionMonitorTcpConfigurationArgs{
 * 						Port: pulumi.Int(80),
 * 					},
 * 					TestFrequencySec: pulumi.Int(60),
 * 				},
 * 			},
 * 			TestGroups: network.ConnectionMonitorTestGroupArray{
 * 				&network.ConnectionMonitorTestGroupArgs{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("destination"),
 * 					},
 * 					Name: pulumi.String("tg"),
 * 					Sources: pulumi.StringArray{
 * 						pulumi.String("source"),
 * 					},
 * 					TestConfigurations: pulumi.StringArray{
 * 						pulumi.String("tcp"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ConnectionMonitor;
 * import com.pulumi.azurenative.network.ConnectionMonitorArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorTestConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorTcpConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorTestGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionMonitor = new ConnectionMonitor("connectionMonitor", ConnectionMonitorArgs.builder()
 *             .connectionMonitorName("cm1")
 *             .endpoints(
 *                 ConnectionMonitorEndpointArgs.builder()
 *                     .name("source")
 *                     .resourceId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/ct1")
 *                     .build(),
 *                 ConnectionMonitorEndpointArgs.builder()
 *                     .address("bing.com")
 *                     .name("destination")
 *                     .build())
 *             .location("eastus")
 *             .networkWatcherName("nw1")
 *             .resourceGroupName("rg1")
 *             .testConfigurations(ConnectionMonitorTestConfigurationArgs.builder()
 *                 .name("tcp")
 *                 .protocol("Tcp")
 *                 .tcpConfiguration(ConnectionMonitorTcpConfigurationArgs.builder()
 *                     .port(80)
 *                     .build())
 *                 .testFrequencySec(60)
 *                 .build())
 *             .testGroups(ConnectionMonitorTestGroupArgs.builder()
 *                 .destinations("destination")
 *                 .name("tg")
 *                 .sources("source")
 *                 .testConfigurations("tcp")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create connection monitor V2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionMonitor = new AzureNative.Network.ConnectionMonitor("connectionMonitor", new()
 *     {
 *         ConnectionMonitorName = "cm1",
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Name = "vm1",
 *                 ResourceId = "/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/NwRgIrinaCentralUSEUAP/providers/Microsoft.Compute/virtualMachines/vm1",
 *             },
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Filter = new AzureNative.Network.Inputs.ConnectionMonitorEndpointFilterArgs
 *                 {
 *                     Items = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ConnectionMonitorEndpointFilterItemArgs
 *                         {
 *                             Address = "npmuser",
 *                             Type = AzureNative.Network.ConnectionMonitorEndpointFilterItemType.AgentAddress,
 *                         },
 *                     },
 *                     Type = AzureNative.Network.ConnectionMonitorEndpointFilterType.Include,
 *                 },
 *                 Name = "CanaryWorkspaceVamshi",
 *                 ResourceId = "/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/vasamudrRG/providers/Microsoft.OperationalInsights/workspaces/vasamudrWorkspace",
 *             },
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Address = "bing.com",
 *                 Name = "bing",
 *             },
 *             new AzureNative.Network.Inputs.ConnectionMonitorEndpointArgs
 *             {
 *                 Address = "google.com",
 *                 Name = "google",
 *             },
 *         },
 *         NetworkWatcherName = "nw1",
 *         Outputs = new[] {},
 *         ResourceGroupName = "rg1",
 *         TestConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorTestConfigurationArgs
 *             {
 *                 Name = "testConfig1",
 *                 Protocol = AzureNative.Network.ConnectionMonitorTestConfigurationProtocol.Tcp,
 *                 TcpConfiguration = new AzureNative.Network.Inputs.ConnectionMonitorTcpConfigurationArgs
 *                 {
 *                     DisableTraceRoute = false,
 *                     Port = 80,
 *                 },
 *                 TestFrequencySec = 60,
 *             },
 *         },
 *         TestGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.ConnectionMonitorTestGroupArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "bing",
 *                     "google",
 *                 },
 *                 Disable = false,
 *                 Name = "test1",
 *                 Sources = new[]
 *                 {
 *                     "vm1",
 *                     "CanaryWorkspaceVamshi",
 *                 },
 *                 TestConfigurations = new[]
 *                 {
 *                     "testConfig1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewConnectionMonitor(ctx, "connectionMonitor", &network.ConnectionMonitorArgs{
 * 			ConnectionMonitorName: pulumi.String("cm1"),
 * 			Endpoints: network.ConnectionMonitorEndpointArray{
 * 				&network.ConnectionMonitorEndpointArgs{
 * 					Name:       pulumi.String("vm1"),
 * 					ResourceId: pulumi.String("/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/NwRgIrinaCentralUSEUAP/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 				},
 * 				&network.ConnectionMonitorEndpointArgs{
 * 					Filter: &network.ConnectionMonitorEndpointFilterArgs{
 * 						Items: network.ConnectionMonitorEndpointFilterItemArray{
 * 							&network.ConnectionMonitorEndpointFilterItemArgs{
 * 								Address: pulumi.String("npmuser"),
 * 								Type:    pulumi.String(network.ConnectionMonitorEndpointFilterItemTypeAgentAddress),
 * 							},
 * 						},
 * 						Type: pulumi.String(network.ConnectionMonitorEndpointFilterTypeInclude),
 * 					},
 * 					Name:       pulumi.String("CanaryWorkspaceVamshi"),
 * 					ResourceId: pulumi.String("/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/vasamudrRG/providers/Microsoft.OperationalInsights/workspaces/vasamudrWorkspace"),
 * 				},
 * 				&network.ConnectionMonitorEndpointArgs{
 * 					Address: pulumi.String("bing.com"),
 * 					Name:    pulumi.String("bing"),
 * 				},
 * 				&network.ConnectionMonitorEndpointArgs{
 * 					Address: pulumi.String("google.com"),
 * 					Name:    pulumi.String("google"),
 * 				},
 * 			},
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			Outputs:            network.ConnectionMonitorOutputTypeArray{},
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			TestConfigurations: network.ConnectionMonitorTestConfigurationArray{
 * 				&network.ConnectionMonitorTestConfigurationArgs{
 * 					Name:     pulumi.String("testConfig1"),
 * 					Protocol: pulumi.String(network.ConnectionMonitorTestConfigurationProtocolTcp),
 * 					TcpConfiguration: &network.ConnectionMonitorTcpConfigurationArgs{
 * 						DisableTraceRoute: pulumi.Bool(false),
 * 						Port:              pulumi.Int(80),
 * 					},
 * 					TestFrequencySec: pulumi.Int(60),
 * 				},
 * 			},
 * 			TestGroups: network.ConnectionMonitorTestGroupArray{
 * 				&network.ConnectionMonitorTestGroupArgs{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("bing"),
 * 						pulumi.String("google"),
 * 					},
 * 					Disable: pulumi.Bool(false),
 * 					Name:    pulumi.String("test1"),
 * 					Sources: pulumi.StringArray{
 * 						pulumi.String("vm1"),
 * 						pulumi.String("CanaryWorkspaceVamshi"),
 * 					},
 * 					TestConfigurations: pulumi.StringArray{
 * 						pulumi.String("testConfig1"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ConnectionMonitor;
 * import com.pulumi.azurenative.network.ConnectionMonitorArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorTestConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorTcpConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.ConnectionMonitorTestGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionMonitor = new ConnectionMonitor("connectionMonitor", ConnectionMonitorArgs.builder()
 *             .connectionMonitorName("cm1")
 *             .endpoints(
 *                 ConnectionMonitorEndpointArgs.builder()
 *                     .name("vm1")
 *                     .resourceId("/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/NwRgIrinaCentralUSEUAP/providers/Microsoft.Compute/virtualMachines/vm1")
 *                     .build(),
 *                 ConnectionMonitorEndpointArgs.builder()
 *                     .filter(ConnectionMonitorEndpointFilterArgs.builder()
 *                         .items(ConnectionMonitorEndpointFilterItemArgs.builder()
 *                             .address("npmuser")
 *                             .type("AgentAddress")
 *                             .build())
 *                         .type("Include")
 *                         .build())
 *                     .name("CanaryWorkspaceVamshi")
 *                     .resourceId("/subscriptions/96e68903-0a56-4819-9987-8d08ad6a1f99/resourceGroups/vasamudrRG/providers/Microsoft.OperationalInsights/workspaces/vasamudrWorkspace")
 *                     .build(),
 *                 ConnectionMonitorEndpointArgs.builder()
 *                     .address("bing.com")
 *                     .name("bing")
 *                     .build(),
 *                 ConnectionMonitorEndpointArgs.builder()
 *                     .address("google.com")
 *                     .name("google")
 *                     .build())
 *             .networkWatcherName("nw1")
 *             .outputs()
 *             .resourceGroupName("rg1")
 *             .testConfigurations(ConnectionMonitorTestConfigurationArgs.builder()
 *                 .name("testConfig1")
 *                 .protocol("Tcp")
 *                 .tcpConfiguration(ConnectionMonitorTcpConfigurationArgs.builder()
 *                     .disableTraceRoute(false)
 *                     .port(80)
 *                     .build())
 *                 .testFrequencySec(60)
 *                 .build())
 *             .testGroups(ConnectionMonitorTestGroupArgs.builder()
 *                 .destinations(
 *                     "bing",
 *                     "google")
 *                 .disable(false)
 *                 .name("test1")
 *                 .sources(
 *                     "vm1",
 *                     "CanaryWorkspaceVamshi")
 *                 .testConfigurations("testConfig1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ConnectionMonitor cm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}
 * ```
 * @property autoStart Determines if the connection monitor will start automatically once created.
 * @property connectionMonitorName The name of the connection monitor.
 * @property destination Describes the destination of connection monitor.
 * @property endpoints List of connection monitor endpoints.
 * @property location Connection monitor location.
 * @property migrate Value indicating whether connection monitor V1 should be migrated to V2 format.
 * @property monitoringIntervalInSeconds Monitoring interval in seconds.
 * @property networkWatcherName The name of the Network Watcher resource.
 * @property notes Optional notes to be associated with the connection monitor.
 * @property outputs List of connection monitor outputs.
 * @property resourceGroupName The name of the resource group containing Network Watcher.
 * @property source Describes the source of connection monitor.
 * @property tags Connection monitor tags.
 * @property testConfigurations List of connection monitor test configurations.
 * @property testGroups List of connection monitor test groups.
 */
public data class ConnectionMonitorArgs(
    public val autoStart: Output<Boolean>? = null,
    public val connectionMonitorName: Output<String>? = null,
    public val destination: Output<ConnectionMonitorDestinationArgs>? = null,
    public val endpoints: Output<List<ConnectionMonitorEndpointArgs>>? = null,
    public val location: Output<String>? = null,
    public val migrate: Output<String>? = null,
    public val monitoringIntervalInSeconds: Output<Int>? = null,
    public val networkWatcherName: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val outputs: Output<List<ConnectionMonitorOutputArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<ConnectionMonitorSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val testConfigurations: Output<List<ConnectionMonitorTestConfigurationArgs>>? = null,
    public val testGroups: Output<List<ConnectionMonitorTestGroupArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ConnectionMonitorArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ConnectionMonitorArgs =
        com.pulumi.azurenative.network.ConnectionMonitorArgs.builder()
            .autoStart(autoStart?.applyValue({ args0 -> args0 }))
            .connectionMonitorName(connectionMonitorName?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .migrate(migrate?.applyValue({ args0 -> args0 }))
            .monitoringIntervalInSeconds(monitoringIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .networkWatcherName(networkWatcherName?.applyValue({ args0 -> args0 }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .outputs(
                outputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .testConfigurations(
                testConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .testGroups(
                testGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionMonitorArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorArgsBuilder internal constructor() {
    private var autoStart: Output<Boolean>? = null

    private var connectionMonitorName: Output<String>? = null

    private var destination: Output<ConnectionMonitorDestinationArgs>? = null

    private var endpoints: Output<List<ConnectionMonitorEndpointArgs>>? = null

    private var location: Output<String>? = null

    private var migrate: Output<String>? = null

    private var monitoringIntervalInSeconds: Output<Int>? = null

    private var networkWatcherName: Output<String>? = null

    private var notes: Output<String>? = null

    private var outputs: Output<List<ConnectionMonitorOutputArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<ConnectionMonitorSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var testConfigurations: Output<List<ConnectionMonitorTestConfigurationArgs>>? = null

    private var testGroups: Output<List<ConnectionMonitorTestGroupArgs>>? = null

    /**
     * @param value Determines if the connection monitor will start automatically once created.
     */
    @JvmName("sufjuifeawrmsity")
    public suspend fun autoStart(`value`: Output<Boolean>) {
        this.autoStart = value
    }

    /**
     * @param value The name of the connection monitor.
     */
    @JvmName("qbaadyaokpurmpwn")
    public suspend fun connectionMonitorName(`value`: Output<String>) {
        this.connectionMonitorName = value
    }

    /**
     * @param value Describes the destination of connection monitor.
     */
    @JvmName("lmujsdgeewskhhss")
    public suspend fun destination(`value`: Output<ConnectionMonitorDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value List of connection monitor endpoints.
     */
    @JvmName("uegdadsevdivaxnf")
    public suspend fun endpoints(`value`: Output<List<ConnectionMonitorEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("idfqoiigvvnaskdi")
    public suspend fun endpoints(vararg values: Output<ConnectionMonitorEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values List of connection monitor endpoints.
     */
    @JvmName("ddtaqsiqcfvtiwrq")
    public suspend fun endpoints(values: List<Output<ConnectionMonitorEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value Connection monitor location.
     */
    @JvmName("mvfsoaopmtmcfluo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Value indicating whether connection monitor V1 should be migrated to V2 format.
     */
    @JvmName("nntxuytchygchwbh")
    public suspend fun migrate(`value`: Output<String>) {
        this.migrate = value
    }

    /**
     * @param value Monitoring interval in seconds.
     */
    @JvmName("eholbeqircupqkhc")
    public suspend fun monitoringIntervalInSeconds(`value`: Output<Int>) {
        this.monitoringIntervalInSeconds = value
    }

    /**
     * @param value The name of the Network Watcher resource.
     */
    @JvmName("nsoasxlbebdreoah")
    public suspend fun networkWatcherName(`value`: Output<String>) {
        this.networkWatcherName = value
    }

    /**
     * @param value Optional notes to be associated with the connection monitor.
     */
    @JvmName("srsgbohjrvbqisjw")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value List of connection monitor outputs.
     */
    @JvmName("kljcjehwehkfoaij")
    public suspend fun outputs(`value`: Output<List<ConnectionMonitorOutputArgs>>) {
        this.outputs = value
    }

    @JvmName("phdganpnhcehcqwx")
    public suspend fun outputs(vararg values: Output<ConnectionMonitorOutputArgs>) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values List of connection monitor outputs.
     */
    @JvmName("spawnjrgockdiumi")
    public suspend fun outputs(values: List<Output<ConnectionMonitorOutputArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value The name of the resource group containing Network Watcher.
     */
    @JvmName("nhrfihbpuuhyhvdb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Describes the source of connection monitor.
     */
    @JvmName("fjiiyarhmturyfdv")
    public suspend fun source(`value`: Output<ConnectionMonitorSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Connection monitor tags.
     */
    @JvmName("bulvevmkeyunvmqd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of connection monitor test configurations.
     */
    @JvmName("pjhfinooxqjrurvu")
    public suspend fun testConfigurations(`value`: Output<List<ConnectionMonitorTestConfigurationArgs>>) {
        this.testConfigurations = value
    }

    @JvmName("wxhqtwlwadclwegk")
    public suspend fun testConfigurations(vararg values: Output<ConnectionMonitorTestConfigurationArgs>) {
        this.testConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of connection monitor test configurations.
     */
    @JvmName("vyinbqyixscoxokw")
    public suspend fun testConfigurations(values: List<Output<ConnectionMonitorTestConfigurationArgs>>) {
        this.testConfigurations = Output.all(values)
    }

    /**
     * @param value List of connection monitor test groups.
     */
    @JvmName("lweynfgrooxkcksr")
    public suspend fun testGroups(`value`: Output<List<ConnectionMonitorTestGroupArgs>>) {
        this.testGroups = value
    }

    @JvmName("xhyjfqhkcokslolv")
    public suspend fun testGroups(vararg values: Output<ConnectionMonitorTestGroupArgs>) {
        this.testGroups = Output.all(values.asList())
    }

    /**
     * @param values List of connection monitor test groups.
     */
    @JvmName("fkwhhwavbcrvbsiu")
    public suspend fun testGroups(values: List<Output<ConnectionMonitorTestGroupArgs>>) {
        this.testGroups = Output.all(values)
    }

    /**
     * @param value Determines if the connection monitor will start automatically once created.
     */
    @JvmName("hawlublwqyeihyka")
    public suspend fun autoStart(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStart = mapped
    }

    /**
     * @param value The name of the connection monitor.
     */
    @JvmName("ylkgufjitdwfxhwd")
    public suspend fun connectionMonitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionMonitorName = mapped
    }

    /**
     * @param value Describes the destination of connection monitor.
     */
    @JvmName("dqtwmhqgetoknhls")
    public suspend fun destination(`value`: ConnectionMonitorDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Describes the destination of connection monitor.
     */
    @JvmName("fwvsnjbgudhlxgwf")
    public suspend fun destination(argument: suspend ConnectionMonitorDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value List of connection monitor endpoints.
     */
    @JvmName("cvjlvkfhlrqtfqng")
    public suspend fun endpoints(`value`: List<ConnectionMonitorEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument List of connection monitor endpoints.
     */
    @JvmName("nbexcpnuhlpevpxk")
    public suspend fun endpoints(argument: List<suspend ConnectionMonitorEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument List of connection monitor endpoints.
     */
    @JvmName("gsfonftygxmiuboy")
    public suspend fun endpoints(vararg argument: suspend ConnectionMonitorEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument List of connection monitor endpoints.
     */
    @JvmName("hfruaxlqmbxjymmi")
    public suspend fun endpoints(argument: suspend ConnectionMonitorEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionMonitorEndpointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values List of connection monitor endpoints.
     */
    @JvmName("grkgblsxcyrvpfef")
    public suspend fun endpoints(vararg values: ConnectionMonitorEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value Connection monitor location.
     */
    @JvmName("ggdglysavyebiurc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Value indicating whether connection monitor V1 should be migrated to V2 format.
     */
    @JvmName("txacpootpnrsrfil")
    public suspend fun migrate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrate = mapped
    }

    /**
     * @param value Monitoring interval in seconds.
     */
    @JvmName("gacuhtlvxbggyave")
    public suspend fun monitoringIntervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringIntervalInSeconds = mapped
    }

    /**
     * @param value The name of the Network Watcher resource.
     */
    @JvmName("mvcllevbcpnuaykx")
    public suspend fun networkWatcherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkWatcherName = mapped
    }

    /**
     * @param value Optional notes to be associated with the connection monitor.
     */
    @JvmName("axhdavslqdmnxcqn")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value List of connection monitor outputs.
     */
    @JvmName("ylvdvtfwybmhjfto")
    public suspend fun outputs(`value`: List<ConnectionMonitorOutputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument List of connection monitor outputs.
     */
    @JvmName("bmhqiqhmrquumehm")
    public suspend fun outputs(argument: List<suspend ConnectionMonitorOutputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorOutputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument List of connection monitor outputs.
     */
    @JvmName("hxveyxkrfncuhniu")
    public suspend fun outputs(vararg argument: suspend ConnectionMonitorOutputArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorOutputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument List of connection monitor outputs.
     */
    @JvmName("rmlbdievynicyrms")
    public suspend fun outputs(argument: suspend ConnectionMonitorOutputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionMonitorOutputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values List of connection monitor outputs.
     */
    @JvmName("kwjlptxrersjufpm")
    public suspend fun outputs(vararg values: ConnectionMonitorOutputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value The name of the resource group containing Network Watcher.
     */
    @JvmName("qodndjaqtbgubheg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Describes the source of connection monitor.
     */
    @JvmName("vgyjdqfdlbohxhfe")
    public suspend fun source(`value`: ConnectionMonitorSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Describes the source of connection monitor.
     */
    @JvmName("gemoaiodjlfljehh")
    public suspend fun source(argument: suspend ConnectionMonitorSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Connection monitor tags.
     */
    @JvmName("fdqkvxacoodrcvcg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Connection monitor tags.
     */
    @JvmName("hcnerderojxycygd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of connection monitor test configurations.
     */
    @JvmName("tnkrqsttqsehfndu")
    public suspend fun testConfigurations(`value`: List<ConnectionMonitorTestConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testConfigurations = mapped
    }

    /**
     * @param argument List of connection monitor test configurations.
     */
    @JvmName("fwhjkinvflvxtrbe")
    public suspend fun testConfigurations(argument: List<suspend ConnectionMonitorTestConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorTestConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.testConfigurations = mapped
    }

    /**
     * @param argument List of connection monitor test configurations.
     */
    @JvmName("daltqqpvngctpiry")
    public suspend fun testConfigurations(vararg argument: suspend ConnectionMonitorTestConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorTestConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.testConfigurations = mapped
    }

    /**
     * @param argument List of connection monitor test configurations.
     */
    @JvmName("qnphgpvhenxcjueo")
    public suspend fun testConfigurations(argument: suspend ConnectionMonitorTestConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionMonitorTestConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.testConfigurations = mapped
    }

    /**
     * @param values List of connection monitor test configurations.
     */
    @JvmName("geeimwcidoudvhqs")
    public suspend fun testConfigurations(vararg values: ConnectionMonitorTestConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testConfigurations = mapped
    }

    /**
     * @param value List of connection monitor test groups.
     */
    @JvmName("erknloqblvqqampo")
    public suspend fun testGroups(`value`: List<ConnectionMonitorTestGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testGroups = mapped
    }

    /**
     * @param argument List of connection monitor test groups.
     */
    @JvmName("iocddkqhjhtlqohs")
    public suspend fun testGroups(argument: List<suspend ConnectionMonitorTestGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorTestGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.testGroups = mapped
    }

    /**
     * @param argument List of connection monitor test groups.
     */
    @JvmName("frpwndiliordqdou")
    public suspend fun testGroups(vararg argument: suspend ConnectionMonitorTestGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorTestGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.testGroups = mapped
    }

    /**
     * @param argument List of connection monitor test groups.
     */
    @JvmName("pqufddrufmtjpulv")
    public suspend fun testGroups(argument: suspend ConnectionMonitorTestGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionMonitorTestGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.testGroups = mapped
    }

    /**
     * @param values List of connection monitor test groups.
     */
    @JvmName("ukwodivyipgpdsbh")
    public suspend fun testGroups(vararg values: ConnectionMonitorTestGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testGroups = mapped
    }

    internal fun build(): ConnectionMonitorArgs = ConnectionMonitorArgs(
        autoStart = autoStart,
        connectionMonitorName = connectionMonitorName,
        destination = destination,
        endpoints = endpoints,
        location = location,
        migrate = migrate,
        monitoringIntervalInSeconds = monitoringIntervalInSeconds,
        networkWatcherName = networkWatcherName,
        notes = notes,
        outputs = outputs,
        resourceGroupName = resourceGroupName,
        source = source,
        tags = tags,
        testConfigurations = testConfigurations,
        testGroups = testGroups,
    )
}
