@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DdosProtectionPlan].
 */
@PulumiTagMarker
public class DdosProtectionPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DdosProtectionPlanArgs = DdosProtectionPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DdosProtectionPlanArgsBuilder.() -> Unit) {
        val builder = DdosProtectionPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DdosProtectionPlan {
        val builtJavaResource =
            com.pulumi.azurenative.network.DdosProtectionPlan(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DdosProtectionPlan(builtJavaResource)
    }
}

/**
 * A DDoS protection plan in a resource group.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-02-01, 2022-05-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create DDoS protection plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ddosProtectionPlan = new AzureNative.Network.DdosProtectionPlan("ddosProtectionPlan", new()
 *     {
 *         DdosProtectionPlanName = "test-plan",
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDdosProtectionPlan(ctx, "ddosProtectionPlan", &network.DdosProtectionPlanArgs{
 * 			DdosProtectionPlanName: pulumi.String("test-plan"),
 * 			Location:               pulumi.String("westus"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DdosProtectionPlan;
 * import com.pulumi.azurenative.network.DdosProtectionPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ddosProtectionPlan = new DdosProtectionPlan("ddosProtectionPlan", DdosProtectionPlanArgs.builder()
 *             .ddosProtectionPlanName("test-plan")
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DdosProtectionPlan test-plan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}
 * ```
 */
public class DdosProtectionPlan internal constructor(
    override val javaResource: com.pulumi.azurenative.network.DdosProtectionPlan,
) : KotlinCustomResource(javaResource, DdosProtectionPlanMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the DDoS protection plan resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The list of public IPs associated with the DDoS protection plan resource. This list is read-only.
     */
    public val publicIPAddresses: Output<List<SubResourceResponse>>
        get() = javaResource.publicIPAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of virtual networks associated with the DDoS protection plan resource. This list is read-only.
     */
    public val virtualNetworks: Output<List<SubResourceResponse>>
        get() = javaResource.virtualNetworks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })
}

public object DdosProtectionPlanMapper : ResourceMapper<DdosProtectionPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.DdosProtectionPlan::class == javaResource::class

    override fun map(javaResource: Resource): DdosProtectionPlan = DdosProtectionPlan(
        javaResource as
            com.pulumi.azurenative.network.DdosProtectionPlan,
    )
}

/**
 * @see [DdosProtectionPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DdosProtectionPlan].
 */
public suspend fun ddosProtectionPlan(
    name: String,
    block: suspend DdosProtectionPlanResourceBuilder.() -> Unit,
): DdosProtectionPlan {
    val builder = DdosProtectionPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DdosProtectionPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ddosProtectionPlan(name: String): DdosProtectionPlan {
    val builder = DdosProtectionPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
