@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin as addressPrefixItemResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DefaultAdminRule].
 */
@PulumiTagMarker
public class DefaultAdminRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultAdminRuleArgs = DefaultAdminRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultAdminRuleArgsBuilder.() -> Unit) {
        val builder = DefaultAdminRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DefaultAdminRule {
        val builtJavaResource = com.pulumi.azurenative.network.DefaultAdminRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultAdminRule(builtJavaResource)
    }
}

/**
 * Network default admin rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * ## Example Usage
 * ### Create a default admin rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultAdminRule = new AzureNative.Network.DefaultAdminRule("defaultAdminRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         Flag = "AllowVnetInbound",
 *         Kind = "Default",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleDefaultAdminRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDefaultAdminRule(ctx, "defaultAdminRule", &network.DefaultAdminRuleArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			Flag:               pulumi.String("AllowVnetInbound"),
 * 			Kind:               pulumi.String("Default"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleDefaultAdminRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DefaultAdminRule;
 * import com.pulumi.azurenative.network.DefaultAdminRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultAdminRule = new DefaultAdminRule("defaultAdminRule", DefaultAdminRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .flag("AllowVnetInbound")
 *             .kind("Default")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleDefaultAdminRule")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an admin rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultAdminRule = new AzureNative.Network.DefaultAdminRule("defaultAdminRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleAdminRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDefaultAdminRule(ctx, "defaultAdminRule", &network.DefaultAdminRuleArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleAdminRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DefaultAdminRule;
 * import com.pulumi.azurenative.network.DefaultAdminRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultAdminRule = new DefaultAdminRule("defaultAdminRule", DefaultAdminRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleAdminRule")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DefaultAdminRule SampleAdminRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityAdminConfigurations/{configurationName}/ruleCollections/{ruleCollectionName}/rules/{ruleName}
 * ```
 */
public class DefaultAdminRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.DefaultAdminRule,
) : KotlinCustomResource(javaResource, DefaultAdminRuleMapper) {
    /**
     * Indicates the access allowed for this particular rule
     */
    public val access: Output<String>
        get() = javaResource.access().applyValue({ args0 -> args0 })

    /**
     * A description for this rule. Restricted to 140 chars.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The destination port ranges.
     */
    public val destinationPortRanges: Output<List<String>>
        get() = javaResource.destinationPortRanges().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The destination address prefixes. CIDR or destination IP ranges.
     */
    public val destinations: Output<List<AddressPrefixItemResponse>>
        get() = javaResource.destinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    addressPrefixItemResponseToKotlin(args0)
                })
            })
        })

    /**
     * Indicates if the traffic matched against the rule in inbound or outbound.
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Default rule flag.
     */
    public val flag: Output<String>?
        get() = javaResource.flag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the rule is custom or default.
     * Expected value is 'Default'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * Network protocol this rule applies to.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for this resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The source port ranges.
     */
    public val sourcePortRanges: Output<List<String>>
        get() = javaResource.sourcePortRanges().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The CIDR or source IP ranges.
     */
    public val sources: Output<List<AddressPrefixItemResponse>>
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    addressPrefixItemResponseToKotlin(args0)
                })
            })
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DefaultAdminRuleMapper : ResourceMapper<DefaultAdminRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.DefaultAdminRule::class == javaResource::class

    override fun map(javaResource: Resource): DefaultAdminRule = DefaultAdminRule(
        javaResource as
            com.pulumi.azurenative.network.DefaultAdminRule,
    )
}

/**
 * @see [DefaultAdminRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultAdminRule].
 */
public suspend fun defaultAdminRule(
    name: String,
    block: suspend DefaultAdminRuleResourceBuilder.() -> Unit,
): DefaultAdminRule {
    val builder = DefaultAdminRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultAdminRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultAdminRule(name: String): DefaultAdminRule {
    val builder = DefaultAdminRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
