@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.DnsResolverArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a DNS resolver.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert DNS resolver
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dnsResolver = new AzureNative.Network.DnsResolver("dnsResolver", new()
 *     {
 *         DnsResolverName = "sampleDnsResolver",
 *         Location = "westus2",
 *         ResourceGroupName = "sampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/cbb1387e-4b03-44f2-ad41-58d4677b9873/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDnsResolver(ctx, "dnsResolver", &network.DnsResolverArgs{
 * 			DnsResolverName:   pulumi.String("sampleDnsResolver"),
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/cbb1387e-4b03-44f2-ad41-58d4677b9873/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DnsResolver;
 * import com.pulumi.azurenative.network.DnsResolverArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dnsResolver = new DnsResolver("dnsResolver", DnsResolverArgs.builder()
 *             .dnsResolverName("sampleDnsResolver")
 *             .location("westus2")
 *             .resourceGroupName("sampleResourceGroup")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualNetwork(SubResourceArgs.builder()
 *                 .id("/subscriptions/cbb1387e-4b03-44f2-ad41-58d4677b9873/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DnsResolver sampleDnsResolver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}
 * ```
 * @property dnsResolverName The name of the DNS resolver.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property virtualNetwork The reference to the virtual network. This cannot be changed after creation.
 */
public data class DnsResolverArgs(
    public val dnsResolverName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNetwork: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.DnsResolverArgs> {
    override fun toJava(): com.pulumi.azurenative.network.DnsResolverArgs =
        com.pulumi.azurenative.network.DnsResolverArgs.builder()
            .dnsResolverName(dnsResolverName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNetwork(
                virtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DnsResolverArgs].
 */
@PulumiTagMarker
public class DnsResolverArgsBuilder internal constructor() {
    private var dnsResolverName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNetwork: Output<SubResourceArgs>? = null

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("hqctytanlesokior")
    public suspend fun dnsResolverName(`value`: Output<String>) {
        this.dnsResolverName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ftlqdlvdpvwsdtof")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mvpksgqhjtwoxkhv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xmxjsntrsqhriavy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The reference to the virtual network. This cannot be changed after creation.
     */
    @JvmName("hegpqcibyddujjsp")
    public suspend fun virtualNetwork(`value`: Output<SubResourceArgs>) {
        this.virtualNetwork = value
    }

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("lnwmmglycbtncwqj")
    public suspend fun dnsResolverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsResolverName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lmjknfjhgkefcqkr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cggoxpucsnupphtf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aslusninahvysiiv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fpqwxugdehsiudkg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The reference to the virtual network. This cannot be changed after creation.
     */
    @JvmName("ufjcoqvfxvueavcf")
    public suspend fun virtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetwork = mapped
    }

    /**
     * @param argument The reference to the virtual network. This cannot be changed after creation.
     */
    @JvmName("druarldqsvtyufyn")
    public suspend fun virtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetwork = mapped
    }

    internal fun build(): DnsResolverArgs = DnsResolverArgs(
        dnsResolverName = dnsResolverName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        virtualNetwork = virtualNetwork,
    )
}
