@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExperimentEndpointResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExperimentEndpointResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Experiment].
 */
@PulumiTagMarker
public class ExperimentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExperimentArgs = ExperimentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExperimentArgsBuilder.() -> Unit) {
        val builder = ExperimentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Experiment {
        val builtJavaResource = com.pulumi.azurenative.network.Experiment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Experiment(builtJavaResource)
    }
}

/**
 * Defines the properties of an Experiment
 * Azure REST API version: 2019-11-01. Prior API version in Azure Native 1.x: 2019-11-01.
 * ## Example Usage
 * ### Creates an Experiment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var experiment = new AzureNative.Network.Experiment("experiment", new()
 *     {
 *         Description = "this is my first experiment!",
 *         EnabledState = AzureNative.Network.State.Enabled,
 *         EndpointA = new AzureNative.Network.Inputs.ExperimentEndpointArgs
 *         {
 *             Endpoint = "endpointA.net",
 *             Name = "endpoint A",
 *         },
 *         EndpointB = new AzureNative.Network.Inputs.ExperimentEndpointArgs
 *         {
 *             Endpoint = "endpointB.net",
 *             Name = "endpoint B",
 *         },
 *         ExperimentName = "MyExperiment",
 *         ProfileName = "MyProfile",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExperiment(ctx, "experiment", &network.ExperimentArgs{
 * 			Description:  pulumi.String("this is my first experiment!"),
 * 			EnabledState: pulumi.String(network.StateEnabled),
 * 			EndpointA: &network.ExperimentEndpointArgs{
 * 				Endpoint: pulumi.String("endpointA.net"),
 * 				Name:     pulumi.String("endpoint A"),
 * 			},
 * 			EndpointB: &network.ExperimentEndpointArgs{
 * 				Endpoint: pulumi.String("endpointB.net"),
 * 				Name:     pulumi.String("endpoint B"),
 * 			},
 * 			ExperimentName:    pulumi.String("MyExperiment"),
 * 			ProfileName:       pulumi.String("MyProfile"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Experiment;
 * import com.pulumi.azurenative.network.ExperimentArgs;
 * import com.pulumi.azurenative.network.inputs.ExperimentEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var experiment = new Experiment("experiment", ExperimentArgs.builder()
 *             .description("this is my first experiment!")
 *             .enabledState("Enabled")
 *             .endpointA(ExperimentEndpointArgs.builder()
 *                 .endpoint("endpointA.net")
 *                 .name("endpoint A")
 *                 .build())
 *             .endpointB(ExperimentEndpointArgs.builder()
 *                 .endpoint("endpointB.net")
 *                 .name("endpoint B")
 *                 .build())
 *             .experimentName("MyExperiment")
 *             .profileName("MyProfile")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Experiment MyExperiment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}
 * ```
 */
public class Experiment internal constructor(
    override val javaResource: com.pulumi.azurenative.network.Experiment,
) : KotlinCustomResource(javaResource, ExperimentMapper) {
    /**
     * The description of the details or intents of the Experiment
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the Experiment
     */
    public val enabledState: Output<String>?
        get() = javaResource.enabledState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The endpoint A of an experiment
     */
    public val endpointA: Output<ExperimentEndpointResponse>?
        get() = javaResource.endpointA().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The endpoint B of an experiment
     */
    public val endpointB: Output<ExperimentEndpointResponse>?
        get() = javaResource.endpointB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource status.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * The uri to the Script used in the Experiment
     */
    public val scriptFileUri: Output<String>
        get() = javaResource.scriptFileUri().applyValue({ args0 -> args0 })

    /**
     * The description of Experiment status from the server side
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExperimentMapper : ResourceMapper<Experiment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.Experiment::class == javaResource::class

    override fun map(javaResource: Resource): Experiment = Experiment(
        javaResource as
            com.pulumi.azurenative.network.Experiment,
    )
}

/**
 * @see [Experiment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Experiment].
 */
public suspend fun experiment(name: String, block: suspend ExperimentResourceBuilder.() -> Unit): Experiment {
    val builder = ExperimentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Experiment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun experiment(name: String): Experiment {
    val builder = ExperimentResourceBuilder()
    builder.name(name)
    return builder.build()
}
