@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExpressRouteCircuitAuthorizationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AuthorizationUseStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authorization in an ExpressRouteCircuit resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create ExpressRouteCircuit Authorization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteCircuitAuthorization = new AzureNative.Network.ExpressRouteCircuitAuthorization("expressRouteCircuitAuthorization", new()
 *     {
 *         AuthorizationName = "authorizatinName",
 *         CircuitName = "circuitName",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteCircuitAuthorization(ctx, "expressRouteCircuitAuthorization", &network.ExpressRouteCircuitAuthorizationArgs{
 * 			AuthorizationName: pulumi.String("authorizatinName"),
 * 			CircuitName:       pulumi.String("circuitName"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitAuthorization;
 * import com.pulumi.azurenative.network.ExpressRouteCircuitAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteCircuitAuthorization = new ExpressRouteCircuitAuthorization("expressRouteCircuitAuthorization", ExpressRouteCircuitAuthorizationArgs.builder()
 *             .authorizationName("authorizatinName")
 *             .circuitName("circuitName")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteCircuitAuthorization authorizationName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/authorizations/{authorizationName}
 * ```
 * @property authorizationKey The authorization key.
 * @property authorizationName The name of the authorization.
 * @property authorizationUseStatus The authorization use status.
 * @property circuitName The name of the express route circuit.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property resourceGroupName The name of the resource group.
 */
public data class ExpressRouteCircuitAuthorizationArgs(
    public val authorizationKey: Output<String>? = null,
    public val authorizationName: Output<String>? = null,
    public val authorizationUseStatus: Output<Either<String, AuthorizationUseStatus>>? = null,
    public val circuitName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExpressRouteCircuitAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExpressRouteCircuitAuthorizationArgs =
        com.pulumi.azurenative.network.ExpressRouteCircuitAuthorizationArgs.builder()
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .authorizationName(authorizationName?.applyValue({ args0 -> args0 }))
            .authorizationUseStatus(
                authorizationUseStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .circuitName(circuitName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitAuthorizationArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitAuthorizationArgsBuilder internal constructor() {
    private var authorizationKey: Output<String>? = null

    private var authorizationName: Output<String>? = null

    private var authorizationUseStatus: Output<Either<String, AuthorizationUseStatus>>? = null

    private var circuitName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The authorization key.
     */
    @JvmName("vqrxssuiuxoxtivr")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value The name of the authorization.
     */
    @JvmName("frsbnnvrhjkfbktm")
    public suspend fun authorizationName(`value`: Output<String>) {
        this.authorizationName = value
    }

    /**
     * @param value The authorization use status.
     */
    @JvmName("ockryqahpkqhlvjd")
    public suspend fun authorizationUseStatus(`value`: Output<Either<String, AuthorizationUseStatus>>) {
        this.authorizationUseStatus = value
    }

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("rwujaabnchbrxgjn")
    public suspend fun circuitName(`value`: Output<String>) {
        this.circuitName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("klravxgicwcmhorj")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("vkjbimebqtvnuaad")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uatqvgrtvpkvevkj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The authorization key.
     */
    @JvmName("kokapyocpirdgohq")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value The name of the authorization.
     */
    @JvmName("lvajmktudryyghos")
    public suspend fun authorizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationName = mapped
    }

    /**
     * @param value The authorization use status.
     */
    @JvmName("nplnnwjufbpuvqvj")
    public suspend fun authorizationUseStatus(`value`: Either<String, AuthorizationUseStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationUseStatus = mapped
    }

    /**
     * @param value The authorization use status.
     */
    @JvmName("vdwbsqpmvuijgwxv")
    public fun authorizationUseStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthorizationUseStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationUseStatus = mapped
    }

    /**
     * @param value The authorization use status.
     */
    @JvmName("pfsxowshnhdwdfer")
    public fun authorizationUseStatus(`value`: AuthorizationUseStatus) {
        val toBeMapped = Either.ofRight<String, AuthorizationUseStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationUseStatus = mapped
    }

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("juqxeagichwfgqav")
    public suspend fun circuitName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.circuitName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("irqpaldpgsmureta")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("dkrntpckgfhwygtm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cydkuyhreviumikc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ExpressRouteCircuitAuthorizationArgs = ExpressRouteCircuitAuthorizationArgs(
        authorizationKey = authorizationKey,
        authorizationName = authorizationName,
        authorizationUseStatus = authorizationUseStatus,
        circuitName = circuitName,
        id = id,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
