@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExpressRouteGatewayArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteConnectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteConnectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualHubIdArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualHubIdArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ExpressRoute gateway resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-03-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### ExpressRouteGatewayCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteGateway = new AzureNative.Network.ExpressRouteGateway("expressRouteGateway", new()
 *     {
 *         AllowNonVirtualWanTraffic = false,
 *         AutoScaleConfiguration = new AzureNative.Network.Inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs
 *         {
 *             Bounds = new AzureNative.Network.Inputs.ExpressRouteGatewayPropertiesBoundsArgs
 *             {
 *                 Min = 3,
 *             },
 *         },
 *         ExpressRouteGatewayName = "gateway-2",
 *         Location = "westus",
 *         ResourceGroupName = "resourceGroupName",
 *         VirtualHub = new AzureNative.Network.Inputs.VirtualHubIdArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/resourceGroupId/providers/Microsoft.Network/virtualHubs/virtualHubName",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRouteGateway(ctx, "expressRouteGateway", &network.ExpressRouteGatewayArgs{
 * 			AllowNonVirtualWanTraffic: pulumi.Bool(false),
 * 			AutoScaleConfiguration: &network.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs{
 * 				Bounds: &network.ExpressRouteGatewayPropertiesBoundsArgs{
 * 					Min: pulumi.Int(3),
 * 				},
 * 			},
 * 			ExpressRouteGatewayName: pulumi.String("gateway-2"),
 * 			Location:                pulumi.String("westus"),
 * 			ResourceGroupName:       pulumi.String("resourceGroupName"),
 * 			VirtualHub: &network.VirtualHubIdArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupId/providers/Microsoft.Network/virtualHubs/virtualHubName"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteGateway;
 * import com.pulumi.azurenative.network.ExpressRouteGatewayArgs;
 * import com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesBoundsArgs;
 * import com.pulumi.azurenative.network.inputs.VirtualHubIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteGateway = new ExpressRouteGateway("expressRouteGateway", ExpressRouteGatewayArgs.builder()
 *             .allowNonVirtualWanTraffic(false)
 *             .autoScaleConfiguration(ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs.builder()
 *                 .bounds(ExpressRouteGatewayPropertiesBoundsArgs.builder()
 *                     .min(3)
 *                     .build())
 *                 .build())
 *             .expressRouteGatewayName("gateway-2")
 *             .location("westus")
 *             .resourceGroupName("resourceGroupName")
 *             .virtualHub(VirtualHubIdArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/resourceGroupId/providers/Microsoft.Network/virtualHubs/virtualHubName")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteGateway gateway-2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}
 * ```
 * @property allowNonVirtualWanTraffic Configures this gateway to accept traffic from non Virtual WAN networks.
 * @property autoScaleConfiguration Configuration for auto scaling.
 * @property expressRouteConnections List of ExpressRoute connections to the ExpressRoute gateway.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property expressRouteGatewayName The name of the ExpressRoute gateway.
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 * @property virtualHub The Virtual Hub where the ExpressRoute gateway is or will be deployed.
 */
public data class ExpressRouteGatewayArgs(
    public val allowNonVirtualWanTraffic: Output<Boolean>? = null,
    public val autoScaleConfiguration: Output<ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs>? = null,
    public val expressRouteConnections: Output<List<ExpressRouteConnectionArgs>>? = null,
    public val expressRouteGatewayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualHub: Output<VirtualHubIdArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExpressRouteGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExpressRouteGatewayArgs =
        com.pulumi.azurenative.network.ExpressRouteGatewayArgs.builder()
            .allowNonVirtualWanTraffic(allowNonVirtualWanTraffic?.applyValue({ args0 -> args0 }))
            .autoScaleConfiguration(
                autoScaleConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .expressRouteConnections(
                expressRouteConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expressRouteGatewayName(expressRouteGatewayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualHub(virtualHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExpressRouteGatewayArgs].
 */
@PulumiTagMarker
public class ExpressRouteGatewayArgsBuilder internal constructor() {
    private var allowNonVirtualWanTraffic: Output<Boolean>? = null

    private var autoScaleConfiguration:
        Output<ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs>? = null

    private var expressRouteConnections: Output<List<ExpressRouteConnectionArgs>>? = null

    private var expressRouteGatewayName: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualHub: Output<VirtualHubIdArgs>? = null

    /**
     * @param value Configures this gateway to accept traffic from non Virtual WAN networks.
     */
    @JvmName("vkmfqauunqcaaguo")
    public suspend fun allowNonVirtualWanTraffic(`value`: Output<Boolean>) {
        this.allowNonVirtualWanTraffic = value
    }

    /**
     * @param value Configuration for auto scaling.
     */
    @JvmName("vullpuyanajlhgix")
    public suspend fun autoScaleConfiguration(`value`: Output<ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs>) {
        this.autoScaleConfiguration = value
    }

    /**
     * @param value List of ExpressRoute connections to the ExpressRoute gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("akuxmkvqukcorpje")
    public suspend fun expressRouteConnections(`value`: Output<List<ExpressRouteConnectionArgs>>) {
        this.expressRouteConnections = value
    }

    @JvmName("gescxrvrgpouamqu")
    public suspend fun expressRouteConnections(vararg values: Output<ExpressRouteConnectionArgs>) {
        this.expressRouteConnections = Output.all(values.asList())
    }

    /**
     * @param values List of ExpressRoute connections to the ExpressRoute gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bfllsxxpeoacojdo")
    public suspend fun expressRouteConnections(values: List<Output<ExpressRouteConnectionArgs>>) {
        this.expressRouteConnections = Output.all(values)
    }

    /**
     * @param value The name of the ExpressRoute gateway.
     */
    @JvmName("vegthixrkacqmxaw")
    public suspend fun expressRouteGatewayName(`value`: Output<String>) {
        this.expressRouteGatewayName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bltofgblkrhqkinv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ttxqcdbaqyygmtht")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sxgslfxefrcpiovx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fflkqikrocagwcsn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     */
    @JvmName("teqievvhendbluxh")
    public suspend fun virtualHub(`value`: Output<VirtualHubIdArgs>) {
        this.virtualHub = value
    }

    /**
     * @param value Configures this gateway to accept traffic from non Virtual WAN networks.
     */
    @JvmName("sjxuitiyqyjwlubu")
    public suspend fun allowNonVirtualWanTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowNonVirtualWanTraffic = mapped
    }

    /**
     * @param value Configuration for auto scaling.
     */
    @JvmName("wwbrcpctoicvujbq")
    public suspend fun autoScaleConfiguration(`value`: ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScaleConfiguration = mapped
    }

    /**
     * @param argument Configuration for auto scaling.
     */
    @JvmName("bbyaolvdfbunwibq")
    public suspend fun autoScaleConfiguration(argument: suspend ExpressRouteGatewayPropertiesAutoScaleConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteGatewayPropertiesAutoScaleConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoScaleConfiguration = mapped
    }

    /**
     * @param value List of ExpressRoute connections to the ExpressRoute gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("dxcjfbxjmtmxyncf")
    public suspend fun expressRouteConnections(`value`: List<ExpressRouteConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteConnections = mapped
    }

    /**
     * @param argument List of ExpressRoute connections to the ExpressRoute gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ccggxttldyvphilm")
    public suspend fun expressRouteConnections(argument: List<suspend ExpressRouteConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressRouteConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.expressRouteConnections = mapped
    }

    /**
     * @param argument List of ExpressRoute connections to the ExpressRoute gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("mqutsfrlmtxvykyq")
    public suspend fun expressRouteConnections(vararg argument: suspend ExpressRouteConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExpressRouteConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.expressRouteConnections = mapped
    }

    /**
     * @param argument List of ExpressRoute connections to the ExpressRoute gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("lojawtbtpvospyww")
    public suspend fun expressRouteConnections(argument: suspend ExpressRouteConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExpressRouteConnectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.expressRouteConnections = mapped
    }

    /**
     * @param values List of ExpressRoute connections to the ExpressRoute gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("plqogvfqfexwedka")
    public suspend fun expressRouteConnections(vararg values: ExpressRouteConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressRouteConnections = mapped
    }

    /**
     * @param value The name of the ExpressRoute gateway.
     */
    @JvmName("guerkfxrdrlhsjby")
    public suspend fun expressRouteGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteGatewayName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jsjyxcrevbvuegwn")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hjcjbxucakpuugik")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("beufjjhiogptdeds")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bodwktfpnwpmkpvm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ibtvqxxrwcnmfksn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     */
    @JvmName("xauoexetcpwuxxqt")
    public suspend fun virtualHub(`value`: VirtualHubIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHub = mapped
    }

    /**
     * @param argument The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     */
    @JvmName("xbbvewfdlmdsrmiw")
    public suspend fun virtualHub(argument: suspend VirtualHubIdArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualHubIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualHub = mapped
    }

    internal fun build(): ExpressRouteGatewayArgs = ExpressRouteGatewayArgs(
        allowNonVirtualWanTraffic = allowNonVirtualWanTraffic,
        autoScaleConfiguration = autoScaleConfiguration,
        expressRouteConnections = expressRouteConnections,
        expressRouteGatewayName = expressRouteGatewayName,
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        virtualHub = virtualHub,
    )
}
