@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.DnsSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExplicitProxyResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyInsightsResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySNATResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySQLResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyThreatIntelWhitelistResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.DnsSettingsResponse.Companion.toKotlin as dnsSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExplicitProxyResponse.Companion.toKotlin as explicitProxyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyInsightsResponse.Companion.toKotlin as firewallPolicyInsightsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionResponse.Companion.toKotlin as firewallPolicyIntrusionDetectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySNATResponse.Companion.toKotlin as firewallPolicySNATResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicySQLResponse.Companion.toKotlin as firewallPolicySQLResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyThreatIntelWhitelistResponse.Companion.toKotlin as firewallPolicyThreatIntelWhitelistResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [FirewallPolicyDraft].
 */
@PulumiTagMarker
public class FirewallPolicyDraftResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallPolicyDraftArgs = FirewallPolicyDraftArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallPolicyDraftArgsBuilder.() -> Unit) {
        val builder = FirewallPolicyDraftArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallPolicyDraft {
        val builtJavaResource =
            com.pulumi.azurenative.network.FirewallPolicyDraft(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallPolicyDraft(builtJavaResource)
    }
}

/**
 * FirewallPolicy Resource.
 * Azure REST API version: 2023-11-01.
 * ## Example Usage
 * ### create or update firewall policy draft
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyDraft = new AzureNative.Network.FirewallPolicyDraft("firewallPolicyDraft", new()
 *     {
 *         DnsSettings = new AzureNative.Network.Inputs.DnsSettingsArgs
 *         {
 *             EnableProxy = true,
 *             RequireProxyForNetworkRules = false,
 *             Servers = new[]
 *             {
 *                 "30.3.4.5",
 *             },
 *         },
 *         ExplicitProxy = new AzureNative.Network.Inputs.ExplicitProxyArgs
 *         {
 *             EnableExplicitProxy = true,
 *             EnablePacFile = true,
 *             HttpPort = 8087,
 *             HttpsPort = 8087,
 *             PacFile = "https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D",
 *             PacFilePort = 8087,
 *         },
 *         FirewallPolicyName = "firewallPolicy",
 *         Insights = new AzureNative.Network.Inputs.FirewallPolicyInsightsArgs
 *         {
 *             IsEnabled = true,
 *             LogAnalyticsResources = new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsResourcesArgs
 *             {
 *                 DefaultWorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace",
 *                 },
 *                 Workspaces = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsWorkspaceArgs
 *                     {
 *                         Region = "westus",
 *                         WorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsWorkspaceArgs
 *                     {
 *                         Region = "eastus",
 *                         WorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2",
 *                         },
 *                     },
 *                 },
 *             },
 *             RetentionDays = 100,
 *         },
 *         IntrusionDetection = new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionArgs
 *         {
 *             Configuration = new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionConfigurationArgs
 *             {
 *                 BypassTrafficSettings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs
 *                     {
 *                         Description = "Rule 1",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "5.6.7.8",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         Name = "bypassRule1",
 *                         Protocol = AzureNative.Network.FirewallPolicyIntrusionDetectionProtocol.TCP,
 *                         SourceAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                     },
 *                 },
 *                 SignatureOverrides = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs
 *                     {
 *                         Id = "2525004",
 *                         Mode = AzureNative.Network.FirewallPolicyIntrusionDetectionStateType.Deny,
 *                     },
 *                 },
 *             },
 *             Mode = AzureNative.Network.FirewallPolicyIntrusionDetectionStateType.Alert,
 *             Profile = "Balanced",
 *         },
 *         ResourceGroupName = "rg1",
 *         Snat = new AzureNative.Network.Inputs.FirewallPolicySNATArgs
 *         {
 *             PrivateRanges = new[]
 *             {
 *                 "IANAPrivateRanges",
 *             },
 *         },
 *         Sql = new AzureNative.Network.Inputs.FirewallPolicySQLArgs
 *         {
 *             AllowSqlRedirect = true,
 *         },
 *         ThreatIntelMode = AzureNative.Network.AzureFirewallThreatIntelMode.Alert,
 *         ThreatIntelWhitelist = new AzureNative.Network.Inputs.FirewallPolicyThreatIntelWhitelistArgs
 *         {
 *             Fqdns = new[]
 *             {
 *                 "*.microsoft.com",
 *             },
 *             IpAddresses = new[]
 *             {
 *                 "20.3.4.5",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyDraft(ctx, "firewallPolicyDraft", &network.FirewallPolicyDraftArgs{
 * 			DnsSettings: &network.DnsSettingsArgs{
 * 				EnableProxy:                 pulumi.Bool(true),
 * 				RequireProxyForNetworkRules: pulumi.Bool(false),
 * 				Servers: pulumi.StringArray{
 * 					pulumi.String("30.3.4.5"),
 * 				},
 * 			},
 * 			ExplicitProxy: &network.ExplicitProxyArgs{
 * 				EnableExplicitProxy: pulumi.Bool(true),
 * 				EnablePacFile:       pulumi.Bool(true),
 * 				HttpPort:            pulumi.Int(8087),
 * 				HttpsPort:           pulumi.Int(8087),
 * 				PacFile:             pulumi.String("https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D"),
 * 				PacFilePort:         pulumi.Int(8087),
 * 			},
 * 			FirewallPolicyName: pulumi.String("firewallPolicy"),
 * 			Insights: &network.FirewallPolicyInsightsArgs{
 * 				IsEnabled: pulumi.Bool(true),
 * 				LogAnalyticsResources: &network.FirewallPolicyLogAnalyticsResourcesArgs{
 * 					DefaultWorkspaceId: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace"),
 * 					},
 * 					Workspaces: network.FirewallPolicyLogAnalyticsWorkspaceArray{
 * 						&network.FirewallPolicyLogAnalyticsWorkspaceArgs{
 * 							Region: pulumi.String("westus"),
 * 							WorkspaceId: &network.SubResourceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1"),
 * 							},
 * 						},
 * 						&network.FirewallPolicyLogAnalyticsWorkspaceArgs{
 * 							Region: pulumi.String("eastus"),
 * 							WorkspaceId: &network.SubResourceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				RetentionDays: pulumi.Int(100),
 * 			},
 * 			IntrusionDetection: &network.FirewallPolicyIntrusionDetectionArgs{
 * 				Configuration: &network.FirewallPolicyIntrusionDetectionConfigurationArgs{
 * 					BypassTrafficSettings: network.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArray{
 * 						&network.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs{
 * 							Description: pulumi.String("Rule 1"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("5.6.7.8"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							Name:     pulumi.String("bypassRule1"),
 * 							Protocol: pulumi.String(network.FirewallPolicyIntrusionDetectionProtocolTCP),
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 						},
 * 					},
 * 					SignatureOverrides: network.FirewallPolicyIntrusionDetectionSignatureSpecificationArray{
 * 						&network.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs{
 * 							Id:   pulumi.String("2525004"),
 * 							Mode: pulumi.String(network.FirewallPolicyIntrusionDetectionStateTypeDeny),
 * 						},
 * 					},
 * 				},
 * 				Mode:    pulumi.String(network.FirewallPolicyIntrusionDetectionStateTypeAlert),
 * 				Profile: pulumi.String("Balanced"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Snat: &network.FirewallPolicySNATArgs{
 * 				PrivateRanges: pulumi.StringArray{
 * 					pulumi.String("IANAPrivateRanges"),
 * 				},
 * 			},
 * 			Sql: &network.FirewallPolicySQLArgs{
 * 				AllowSqlRedirect: pulumi.Bool(true),
 * 			},
 * 			ThreatIntelMode: pulumi.String(network.AzureFirewallThreatIntelModeAlert),
 * 			ThreatIntelWhitelist: &network.FirewallPolicyThreatIntelWhitelistArgs{
 * 				Fqdns: pulumi.StringArray{
 * 					pulumi.String("*.microsoft.com"),
 * 				},
 * 				IpAddresses: pulumi.StringArray{
 * 					pulumi.String("20.3.4.5"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyDraft;
 * import com.pulumi.azurenative.network.FirewallPolicyDraftArgs;
 * import com.pulumi.azurenative.network.inputs.DnsSettingsArgs;
 * import com.pulumi.azurenative.network.inputs.ExplicitProxyArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyInsightsArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsResourcesArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicySNATArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicySQLArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyThreatIntelWhitelistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyDraft = new FirewallPolicyDraft("firewallPolicyDraft", FirewallPolicyDraftArgs.builder()
 *             .dnsSettings(DnsSettingsArgs.builder()
 *                 .enableProxy(true)
 *                 .requireProxyForNetworkRules(false)
 *                 .servers("30.3.4.5")
 *                 .build())
 *             .explicitProxy(ExplicitProxyArgs.builder()
 *                 .enableExplicitProxy(true)
 *                 .enablePacFile(true)
 *                 .httpPort(8087)
 *                 .httpsPort(8087)
 *                 .pacFile("https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D")
 *                 .pacFilePort(8087)
 *                 .build())
 *             .firewallPolicyName("firewallPolicy")
 *             .insights(FirewallPolicyInsightsArgs.builder()
 *                 .isEnabled(true)
 *                 .logAnalyticsResources(FirewallPolicyLogAnalyticsResourcesArgs.builder()
 *                     .defaultWorkspaceId(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace")
 *                         .build())
 *                     .workspaces(
 *                         FirewallPolicyLogAnalyticsWorkspaceArgs.builder()
 *                             .region("westus")
 *                             .workspaceId(SubResourceArgs.builder()
 *                                 .id("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1")
 *                                 .build())
 *                             .build(),
 *                         FirewallPolicyLogAnalyticsWorkspaceArgs.builder()
 *                             .region("eastus")
 *                             .workspaceId(SubResourceArgs.builder()
 *                                 .id("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2")
 *                                 .build())
 *                             .build())
 *                     .build())
 *                 .retentionDays(100)
 *                 .build())
 *             .intrusionDetection(FirewallPolicyIntrusionDetectionArgs.builder()
 *                 .configuration(FirewallPolicyIntrusionDetectionConfigurationArgs.builder()
 *                     .bypassTrafficSettings(FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs.builder()
 *                         .description("Rule 1")
 *                         .destinationAddresses("5.6.7.8")
 *                         .destinationPorts("*")
 *                         .name("bypassRule1")
 *                         .protocol("TCP")
 *                         .sourceAddresses("1.2.3.4")
 *                         .build())
 *                     .signatureOverrides(FirewallPolicyIntrusionDetectionSignatureSpecificationArgs.builder()
 *                         .id("2525004")
 *                         .mode("Deny")
 *                         .build())
 *                     .build())
 *                 .mode("Alert")
 *                 .profile("Balanced")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .snat(FirewallPolicySNATArgs.builder()
 *                 .privateRanges("IANAPrivateRanges")
 *                 .build())
 *             .sql(FirewallPolicySQLArgs.builder()
 *                 .allowSqlRedirect(true)
 *                 .build())
 *             .threatIntelMode("Alert")
 *             .threatIntelWhitelist(FirewallPolicyThreatIntelWhitelistArgs.builder()
 *                 .fqdns("*.microsoft.com")
 *                 .ipAddresses("20.3.4.5")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicyDraft firewallPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/firewallPolicyDrafts/default
 * ```
 */
public class FirewallPolicyDraft internal constructor(
    override val javaResource: com.pulumi.azurenative.network.FirewallPolicyDraft,
) : KotlinCustomResource(javaResource, FirewallPolicyDraftMapper) {
    /**
     * The parent firewall policy from which rules are inherited.
     */
    public val basePolicy: Output<SubResourceResponse>?
        get() = javaResource.basePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * DNS Proxy Settings definition.
     */
    public val dnsSettings: Output<DnsSettingsResponse>?
        get() = javaResource.dnsSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dnsSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Explicit Proxy Settings definition.
     */
    public val explicitProxy: Output<ExplicitProxyResponse>?
        get() = javaResource.explicitProxy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> explicitProxyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Insights on Firewall Policy.
     */
    public val insights: Output<FirewallPolicyInsightsResponse>?
        get() = javaResource.insights().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicyInsightsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration for Intrusion detection.
     */
    public val intrusionDetection: Output<FirewallPolicyIntrusionDetectionResponse>?
        get() = javaResource.intrusionDetection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicyIntrusionDetectionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    public val snat: Output<FirewallPolicySNATResponse>?
        get() = javaResource.snat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicySNATResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * SQL Settings definition.
     */
    public val sql: Output<FirewallPolicySQLResponse>?
        get() = javaResource.sql().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicySQLResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The operation mode for Threat Intelligence.
     */
    public val threatIntelMode: Output<String>?
        get() = javaResource.threatIntelMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ThreatIntel Whitelist for Firewall Policy.
     */
    public val threatIntelWhitelist: Output<FirewallPolicyThreatIntelWhitelistResponse>?
        get() = javaResource.threatIntelWhitelist().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firewallPolicyThreatIntelWhitelistResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallPolicyDraftMapper : ResourceMapper<FirewallPolicyDraft> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.FirewallPolicyDraft::class == javaResource::class

    override fun map(javaResource: Resource): FirewallPolicyDraft = FirewallPolicyDraft(
        javaResource
            as com.pulumi.azurenative.network.FirewallPolicyDraft,
    )
}

/**
 * @see [FirewallPolicyDraft].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallPolicyDraft].
 */
public suspend fun firewallPolicyDraft(
    name: String,
    block: suspend FirewallPolicyDraftResourceBuilder.() -> Unit,
): FirewallPolicyDraft {
    val builder = FirewallPolicyDraftResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallPolicyDraft].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallPolicyDraft(name: String): FirewallPolicyDraft {
    val builder = FirewallPolicyDraftResourceBuilder()
    builder.name(name)
    return builder.build()
}
