@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.FirewallPolicyDraftArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallThreatIntelMode
import com.pulumi.azurenative.network.kotlin.inputs.DnsSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.DnsSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExplicitProxyArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExplicitProxyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyInsightsArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyInsightsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyIntrusionDetectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyIntrusionDetectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySNATArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySNATArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySQLArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySQLArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyThreatIntelWhitelistArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyThreatIntelWhitelistArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * FirewallPolicy Resource.
 * Azure REST API version: 2023-11-01.
 * ## Example Usage
 * ### create or update firewall policy draft
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyDraft = new AzureNative.Network.FirewallPolicyDraft("firewallPolicyDraft", new()
 *     {
 *         DnsSettings = new AzureNative.Network.Inputs.DnsSettingsArgs
 *         {
 *             EnableProxy = true,
 *             RequireProxyForNetworkRules = false,
 *             Servers = new[]
 *             {
 *                 "30.3.4.5",
 *             },
 *         },
 *         ExplicitProxy = new AzureNative.Network.Inputs.ExplicitProxyArgs
 *         {
 *             EnableExplicitProxy = true,
 *             EnablePacFile = true,
 *             HttpPort = 8087,
 *             HttpsPort = 8087,
 *             PacFile = "https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D",
 *             PacFilePort = 8087,
 *         },
 *         FirewallPolicyName = "firewallPolicy",
 *         Insights = new AzureNative.Network.Inputs.FirewallPolicyInsightsArgs
 *         {
 *             IsEnabled = true,
 *             LogAnalyticsResources = new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsResourcesArgs
 *             {
 *                 DefaultWorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace",
 *                 },
 *                 Workspaces = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsWorkspaceArgs
 *                     {
 *                         Region = "westus",
 *                         WorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsWorkspaceArgs
 *                     {
 *                         Region = "eastus",
 *                         WorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2",
 *                         },
 *                     },
 *                 },
 *             },
 *             RetentionDays = 100,
 *         },
 *         IntrusionDetection = new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionArgs
 *         {
 *             Configuration = new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionConfigurationArgs
 *             {
 *                 BypassTrafficSettings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs
 *                     {
 *                         Description = "Rule 1",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "5.6.7.8",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         Name = "bypassRule1",
 *                         Protocol = AzureNative.Network.FirewallPolicyIntrusionDetectionProtocol.TCP,
 *                         SourceAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                     },
 *                 },
 *                 SignatureOverrides = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs
 *                     {
 *                         Id = "2525004",
 *                         Mode = AzureNative.Network.FirewallPolicyIntrusionDetectionStateType.Deny,
 *                     },
 *                 },
 *             },
 *             Mode = AzureNative.Network.FirewallPolicyIntrusionDetectionStateType.Alert,
 *             Profile = "Balanced",
 *         },
 *         ResourceGroupName = "rg1",
 *         Snat = new AzureNative.Network.Inputs.FirewallPolicySNATArgs
 *         {
 *             PrivateRanges = new[]
 *             {
 *                 "IANAPrivateRanges",
 *             },
 *         },
 *         Sql = new AzureNative.Network.Inputs.FirewallPolicySQLArgs
 *         {
 *             AllowSqlRedirect = true,
 *         },
 *         ThreatIntelMode = AzureNative.Network.AzureFirewallThreatIntelMode.Alert,
 *         ThreatIntelWhitelist = new AzureNative.Network.Inputs.FirewallPolicyThreatIntelWhitelistArgs
 *         {
 *             Fqdns = new[]
 *             {
 *                 "*.microsoft.com",
 *             },
 *             IpAddresses = new[]
 *             {
 *                 "20.3.4.5",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyDraft(ctx, "firewallPolicyDraft", &network.FirewallPolicyDraftArgs{
 * 			DnsSettings: &network.DnsSettingsArgs{
 * 				EnableProxy:                 pulumi.Bool(true),
 * 				RequireProxyForNetworkRules: pulumi.Bool(false),
 * 				Servers: pulumi.StringArray{
 * 					pulumi.String("30.3.4.5"),
 * 				},
 * 			},
 * 			ExplicitProxy: &network.ExplicitProxyArgs{
 * 				EnableExplicitProxy: pulumi.Bool(true),
 * 				EnablePacFile:       pulumi.Bool(true),
 * 				HttpPort:            pulumi.Int(8087),
 * 				HttpsPort:           pulumi.Int(8087),
 * 				PacFile:             pulumi.String("https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D"),
 * 				PacFilePort:         pulumi.Int(8087),
 * 			},
 * 			FirewallPolicyName: pulumi.String("firewallPolicy"),
 * 			Insights: &network.FirewallPolicyInsightsArgs{
 * 				IsEnabled: pulumi.Bool(true),
 * 				LogAnalyticsResources: &network.FirewallPolicyLogAnalyticsResourcesArgs{
 * 					DefaultWorkspaceId: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace"),
 * 					},
 * 					Workspaces: network.FirewallPolicyLogAnalyticsWorkspaceArray{
 * 						&network.FirewallPolicyLogAnalyticsWorkspaceArgs{
 * 							Region: pulumi.String("westus"),
 * 							WorkspaceId: &network.SubResourceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1"),
 * 							},
 * 						},
 * 						&network.FirewallPolicyLogAnalyticsWorkspaceArgs{
 * 							Region: pulumi.String("eastus"),
 * 							WorkspaceId: &network.SubResourceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				RetentionDays: pulumi.Int(100),
 * 			},
 * 			IntrusionDetection: &network.FirewallPolicyIntrusionDetectionArgs{
 * 				Configuration: &network.FirewallPolicyIntrusionDetectionConfigurationArgs{
 * 					BypassTrafficSettings: network.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArray{
 * 						&network.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs{
 * 							Description: pulumi.String("Rule 1"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("5.6.7.8"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							Name:     pulumi.String("bypassRule1"),
 * 							Protocol: pulumi.String(network.FirewallPolicyIntrusionDetectionProtocolTCP),
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 						},
 * 					},
 * 					SignatureOverrides: network.FirewallPolicyIntrusionDetectionSignatureSpecificationArray{
 * 						&network.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs{
 * 							Id:   pulumi.String("2525004"),
 * 							Mode: pulumi.String(network.FirewallPolicyIntrusionDetectionStateTypeDeny),
 * 						},
 * 					},
 * 				},
 * 				Mode:    pulumi.String(network.FirewallPolicyIntrusionDetectionStateTypeAlert),
 * 				Profile: pulumi.String("Balanced"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Snat: &network.FirewallPolicySNATArgs{
 * 				PrivateRanges: pulumi.StringArray{
 * 					pulumi.String("IANAPrivateRanges"),
 * 				},
 * 			},
 * 			Sql: &network.FirewallPolicySQLArgs{
 * 				AllowSqlRedirect: pulumi.Bool(true),
 * 			},
 * 			ThreatIntelMode: pulumi.String(network.AzureFirewallThreatIntelModeAlert),
 * 			ThreatIntelWhitelist: &network.FirewallPolicyThreatIntelWhitelistArgs{
 * 				Fqdns: pulumi.StringArray{
 * 					pulumi.String("*.microsoft.com"),
 * 				},
 * 				IpAddresses: pulumi.StringArray{
 * 					pulumi.String("20.3.4.5"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyDraft;
 * import com.pulumi.azurenative.network.FirewallPolicyDraftArgs;
 * import com.pulumi.azurenative.network.inputs.DnsSettingsArgs;
 * import com.pulumi.azurenative.network.inputs.ExplicitProxyArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyInsightsArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsResourcesArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicySNATArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicySQLArgs;
 * import com.pulumi.azurenative.network.inputs.FirewallPolicyThreatIntelWhitelistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyDraft = new FirewallPolicyDraft("firewallPolicyDraft", FirewallPolicyDraftArgs.builder()
 *             .dnsSettings(DnsSettingsArgs.builder()
 *                 .enableProxy(true)
 *                 .requireProxyForNetworkRules(false)
 *                 .servers("30.3.4.5")
 *                 .build())
 *             .explicitProxy(ExplicitProxyArgs.builder()
 *                 .enableExplicitProxy(true)
 *                 .enablePacFile(true)
 *                 .httpPort(8087)
 *                 .httpsPort(8087)
 *                 .pacFile("https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D")
 *                 .pacFilePort(8087)
 *                 .build())
 *             .firewallPolicyName("firewallPolicy")
 *             .insights(FirewallPolicyInsightsArgs.builder()
 *                 .isEnabled(true)
 *                 .logAnalyticsResources(FirewallPolicyLogAnalyticsResourcesArgs.builder()
 *                     .defaultWorkspaceId(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace")
 *                         .build())
 *                     .workspaces(
 *                         FirewallPolicyLogAnalyticsWorkspaceArgs.builder()
 *                             .region("westus")
 *                             .workspaceId(SubResourceArgs.builder()
 *                                 .id("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1")
 *                                 .build())
 *                             .build(),
 *                         FirewallPolicyLogAnalyticsWorkspaceArgs.builder()
 *                             .region("eastus")
 *                             .workspaceId(SubResourceArgs.builder()
 *                                 .id("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2")
 *                                 .build())
 *                             .build())
 *                     .build())
 *                 .retentionDays(100)
 *                 .build())
 *             .intrusionDetection(FirewallPolicyIntrusionDetectionArgs.builder()
 *                 .configuration(FirewallPolicyIntrusionDetectionConfigurationArgs.builder()
 *                     .bypassTrafficSettings(FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs.builder()
 *                         .description("Rule 1")
 *                         .destinationAddresses("5.6.7.8")
 *                         .destinationPorts("*")
 *                         .name("bypassRule1")
 *                         .protocol("TCP")
 *                         .sourceAddresses("1.2.3.4")
 *                         .build())
 *                     .signatureOverrides(FirewallPolicyIntrusionDetectionSignatureSpecificationArgs.builder()
 *                         .id("2525004")
 *                         .mode("Deny")
 *                         .build())
 *                     .build())
 *                 .mode("Alert")
 *                 .profile("Balanced")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .snat(FirewallPolicySNATArgs.builder()
 *                 .privateRanges("IANAPrivateRanges")
 *                 .build())
 *             .sql(FirewallPolicySQLArgs.builder()
 *                 .allowSqlRedirect(true)
 *                 .build())
 *             .threatIntelMode("Alert")
 *             .threatIntelWhitelist(FirewallPolicyThreatIntelWhitelistArgs.builder()
 *                 .fqdns("*.microsoft.com")
 *                 .ipAddresses("20.3.4.5")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicyDraft firewallPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/firewallPolicyDrafts/default
 * ```
 * @property basePolicy The parent firewall policy from which rules are inherited.
 * @property dnsSettings DNS Proxy Settings definition.
 * @property explicitProxy Explicit Proxy Settings definition.
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property id Resource ID.
 * @property insights Insights on Firewall Policy.
 * @property intrusionDetection The configuration for Intrusion detection.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property snat The private IP addresses/IP ranges to which traffic will not be SNAT.
 * @property sql SQL Settings definition.
 * @property tags Resource tags.
 * @property threatIntelMode The operation mode for Threat Intelligence.
 * @property threatIntelWhitelist ThreatIntel Whitelist for Firewall Policy.
 */
public data class FirewallPolicyDraftArgs(
    public val basePolicy: Output<SubResourceArgs>? = null,
    public val dnsSettings: Output<DnsSettingsArgs>? = null,
    public val explicitProxy: Output<ExplicitProxyArgs>? = null,
    public val firewallPolicyName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val insights: Output<FirewallPolicyInsightsArgs>? = null,
    public val intrusionDetection: Output<FirewallPolicyIntrusionDetectionArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val snat: Output<FirewallPolicySNATArgs>? = null,
    public val sql: Output<FirewallPolicySQLArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val threatIntelMode: Output<Either<String, AzureFirewallThreatIntelMode>>? = null,
    public val threatIntelWhitelist: Output<FirewallPolicyThreatIntelWhitelistArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.FirewallPolicyDraftArgs> {
    override fun toJava(): com.pulumi.azurenative.network.FirewallPolicyDraftArgs =
        com.pulumi.azurenative.network.FirewallPolicyDraftArgs.builder()
            .basePolicy(basePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .explicitProxy(explicitProxy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firewallPolicyName(firewallPolicyName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .insights(insights?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intrusionDetection(
                intrusionDetection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .snat(snat?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sql(sql?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .threatIntelMode(
                threatIntelMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .threatIntelWhitelist(
                threatIntelWhitelist?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyDraftArgs].
 */
@PulumiTagMarker
public class FirewallPolicyDraftArgsBuilder internal constructor() {
    private var basePolicy: Output<SubResourceArgs>? = null

    private var dnsSettings: Output<DnsSettingsArgs>? = null

    private var explicitProxy: Output<ExplicitProxyArgs>? = null

    private var firewallPolicyName: Output<String>? = null

    private var id: Output<String>? = null

    private var insights: Output<FirewallPolicyInsightsArgs>? = null

    private var intrusionDetection: Output<FirewallPolicyIntrusionDetectionArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var snat: Output<FirewallPolicySNATArgs>? = null

    private var sql: Output<FirewallPolicySQLArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var threatIntelMode: Output<Either<String, AzureFirewallThreatIntelMode>>? = null

    private var threatIntelWhitelist: Output<FirewallPolicyThreatIntelWhitelistArgs>? = null

    /**
     * @param value The parent firewall policy from which rules are inherited.
     */
    @JvmName("kcteahgttiibndbe")
    public suspend fun basePolicy(`value`: Output<SubResourceArgs>) {
        this.basePolicy = value
    }

    /**
     * @param value DNS Proxy Settings definition.
     */
    @JvmName("tcruarrlltarfctl")
    public suspend fun dnsSettings(`value`: Output<DnsSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value Explicit Proxy Settings definition.
     */
    @JvmName("bjugoewihpsndfyn")
    public suspend fun explicitProxy(`value`: Output<ExplicitProxyArgs>) {
        this.explicitProxy = value
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("qkvqsmxkcptkpmoc")
    public suspend fun firewallPolicyName(`value`: Output<String>) {
        this.firewallPolicyName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dupykgpkgxkowdem")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Insights on Firewall Policy.
     */
    @JvmName("haivantsxmybyuqj")
    public suspend fun insights(`value`: Output<FirewallPolicyInsightsArgs>) {
        this.insights = value
    }

    /**
     * @param value The configuration for Intrusion detection.
     */
    @JvmName("illbvohtmqeuvgah")
    public suspend fun intrusionDetection(`value`: Output<FirewallPolicyIntrusionDetectionArgs>) {
        this.intrusionDetection = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("macgtlqcsijdstof")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rawqnseamnnnrtpp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    @JvmName("cwscrcdvuxfnelyg")
    public suspend fun snat(`value`: Output<FirewallPolicySNATArgs>) {
        this.snat = value
    }

    /**
     * @param value SQL Settings definition.
     */
    @JvmName("uxtdinyfnwddahbx")
    public suspend fun sql(`value`: Output<FirewallPolicySQLArgs>) {
        this.sql = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wsfftxuxbipbqmlm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("tkyotsbvssuwfckb")
    public suspend fun threatIntelMode(`value`: Output<Either<String, AzureFirewallThreatIntelMode>>) {
        this.threatIntelMode = value
    }

    /**
     * @param value ThreatIntel Whitelist for Firewall Policy.
     */
    @JvmName("ynvgfgglnqdnwswi")
    public suspend fun threatIntelWhitelist(`value`: Output<FirewallPolicyThreatIntelWhitelistArgs>) {
        this.threatIntelWhitelist = value
    }

    /**
     * @param value The parent firewall policy from which rules are inherited.
     */
    @JvmName("cirhyhhquwkbivhc")
    public suspend fun basePolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basePolicy = mapped
    }

    /**
     * @param argument The parent firewall policy from which rules are inherited.
     */
    @JvmName("cnwiqigtamgvcomw")
    public suspend fun basePolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.basePolicy = mapped
    }

    /**
     * @param value DNS Proxy Settings definition.
     */
    @JvmName("sqwtlmodkamgjinq")
    public suspend fun dnsSettings(`value`: DnsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument DNS Proxy Settings definition.
     */
    @JvmName("baripxmrebufgavc")
    public suspend fun dnsSettings(argument: suspend DnsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DnsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value Explicit Proxy Settings definition.
     */
    @JvmName("phhaifapxrrhoepy")
    public suspend fun explicitProxy(`value`: ExplicitProxyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.explicitProxy = mapped
    }

    /**
     * @param argument Explicit Proxy Settings definition.
     */
    @JvmName("ahagyvwmcsagkdul")
    public suspend fun explicitProxy(argument: suspend ExplicitProxyArgsBuilder.() -> Unit) {
        val toBeMapped = ExplicitProxyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.explicitProxy = mapped
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("qmqbvtgnwhbyagww")
    public suspend fun firewallPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dyxhphrgpgoelxpc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Insights on Firewall Policy.
     */
    @JvmName("fhtsdcxceoyjmtgj")
    public suspend fun insights(`value`: FirewallPolicyInsightsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insights = mapped
    }

    /**
     * @param argument Insights on Firewall Policy.
     */
    @JvmName("ccskrodrnpffnwmh")
    public suspend fun insights(argument: suspend FirewallPolicyInsightsArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyInsightsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.insights = mapped
    }

    /**
     * @param value The configuration for Intrusion detection.
     */
    @JvmName("huvcsedcjmcdyhmb")
    public suspend fun intrusionDetection(`value`: FirewallPolicyIntrusionDetectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intrusionDetection = mapped
    }

    /**
     * @param argument The configuration for Intrusion detection.
     */
    @JvmName("nuswisvllpjxreuf")
    public suspend fun intrusionDetection(argument: suspend FirewallPolicyIntrusionDetectionArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyIntrusionDetectionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.intrusionDetection = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rldpaqoyjsvngeer")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vbynypvxantjendd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    @JvmName("qpllixwryphwxhui")
    public suspend fun snat(`value`: FirewallPolicySNATArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snat = mapped
    }

    /**
     * @param argument The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    @JvmName("qephhnufpnqsciuf")
    public suspend fun snat(argument: suspend FirewallPolicySNATArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicySNATArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snat = mapped
    }

    /**
     * @param value SQL Settings definition.
     */
    @JvmName("ssyeliyvxulkdojb")
    public suspend fun sql(`value`: FirewallPolicySQLArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sql = mapped
    }

    /**
     * @param argument SQL Settings definition.
     */
    @JvmName("dhrwlsvctnjshabf")
    public suspend fun sql(argument: suspend FirewallPolicySQLArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicySQLArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sql = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("myufckkijpeprxtx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jqqrwaxqeedxmkcq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("cdqbwkptlatowcoq")
    public suspend fun threatIntelMode(`value`: Either<String, AzureFirewallThreatIntelMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("yapkbkujlbqmjwfc")
    public fun threatIntelMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureFirewallThreatIntelMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("kbaontdfjjpadaqh")
    public fun threatIntelMode(`value`: AzureFirewallThreatIntelMode) {
        val toBeMapped = Either.ofRight<String, AzureFirewallThreatIntelMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value ThreatIntel Whitelist for Firewall Policy.
     */
    @JvmName("obiucegiyrjwejgw")
    public suspend fun threatIntelWhitelist(`value`: FirewallPolicyThreatIntelWhitelistArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelWhitelist = mapped
    }

    /**
     * @param argument ThreatIntel Whitelist for Firewall Policy.
     */
    @JvmName("vtjbkvmjrhwwvcvw")
    public suspend fun threatIntelWhitelist(argument: suspend FirewallPolicyThreatIntelWhitelistArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyThreatIntelWhitelistArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.threatIntelWhitelist = mapped
    }

    internal fun build(): FirewallPolicyDraftArgs = FirewallPolicyDraftArgs(
        basePolicy = basePolicy,
        dnsSettings = dnsSettings,
        explicitProxy = explicitProxy,
        firewallPolicyName = firewallPolicyName,
        id = id,
        insights = insights,
        intrusionDetection = intrusionDetection,
        location = location,
        resourceGroupName = resourceGroupName,
        snat = snat,
        sql = sql,
        tags = tags,
        threatIntelMode = threatIntelMode,
        threatIntelWhitelist = threatIntelWhitelist,
    )
}
