@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleCollectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleCollectionResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FirewallPolicyRuleCollectionGroupDraft].
 */
@PulumiTagMarker
public class FirewallPolicyRuleCollectionGroupDraftResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallPolicyRuleCollectionGroupDraftArgs =
        FirewallPolicyRuleCollectionGroupDraftArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallPolicyRuleCollectionGroupDraftArgsBuilder.() -> Unit) {
        val builder = FirewallPolicyRuleCollectionGroupDraftArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallPolicyRuleCollectionGroupDraft {
        val builtJavaResource =
            com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraft(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallPolicyRuleCollectionGroupDraft(builtJavaResource)
    }
}

/**
 * Rule Collection Group resource.
 * Azure REST API version: 2023-11-01.
 * ## Example Usage
 * ### create or update rule collection group draft
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleCollectionGroupDraft = new AzureNative.Network.FirewallPolicyRuleCollectionGroupDraft("firewallPolicyRuleCollectionGroupDraft", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 100,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionGroupName = "ruleCollectionGroup1",
 *         RuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleCollectionActionArgs
 *                 {
 *                     Type = AzureNative.Network.FirewallPolicyFilterRuleCollectionActionType.Deny,
 *                 },
 *                 Name = "Example-Filter-Rule-Collection",
 *                 Priority = 100,
 *                 RuleCollectionType = "FirewallPolicyFilterRuleCollection",
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleArgs
 *                     {
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             AzureNative.Network.FirewallPolicyRuleNetworkProtocol.TCP,
 *                         },
 *                         Name = "network-rule1",
 *                         RuleType = "NetworkRule",
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.1.25.0/24",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleCollectionGroupDraft(ctx, "firewallPolicyRuleCollectionGroupDraft", &network.FirewallPolicyRuleCollectionGroupDraftArgs{
 * 			FirewallPolicyName:      pulumi.String("firewallPolicy"),
 * 			Priority:                pulumi.Int(100),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			RuleCollectionGroupName: pulumi.String("ruleCollectionGroup1"),
 * 			RuleCollections: pulumi.Array{
 * 				network.FirewallPolicyFilterRuleCollection{
 * 					Action: network.FirewallPolicyFilterRuleCollectionAction{
 * 						Type: network.FirewallPolicyFilterRuleCollectionActionTypeDeny,
 * 					},
 * 					Name:               "Example-Filter-Rule-Collection",
 * 					Priority:           100,
 * 					RuleCollectionType: "FirewallPolicyFilterRuleCollection",
 * 					Rules: []interface{}{
 * 						network.NetworkRule{
 * 							DestinationAddresses: []string{
 * 								"*",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleNetworkProtocol{
 * 								network.FirewallPolicyRuleNetworkProtocolTCP,
 * 							},
 * 							Name:     "network-rule1",
 * 							RuleType: "NetworkRule",
 * 							SourceAddresses: []string{
 * 								"10.1.25.0/24",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraft;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraftArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleCollectionGroupDraft = new FirewallPolicyRuleCollectionGroupDraft("firewallPolicyRuleCollectionGroupDraft", FirewallPolicyRuleCollectionGroupDraftArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(100)
 *             .resourceGroupName("rg1")
 *             .ruleCollectionGroupName("ruleCollectionGroup1")
 *             .ruleCollections(FirewallPolicyFilterRuleCollectionArgs.builder()
 *                 .action(FirewallPolicyFilterRuleCollectionActionArgs.builder()
 *                     .type("Deny")
 *                     .build())
 *                 .name("Example-Filter-Rule-Collection")
 *                 .priority(100)
 *                 .ruleCollectionType("FirewallPolicyFilterRuleCollection")
 *                 .rules(NetworkRuleArgs.builder()
 *                     .destinationAddresses("*")
 *                     .destinationPorts("*")
 *                     .ipProtocols("TCP")
 *                     .name("network-rule1")
 *                     .ruleType("NetworkRule")
 *                     .sourceAddresses("10.1.25.0/24")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicyRuleCollectionGroupDraft ruleCollectionGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleCollectionGroups/{ruleCollectionGroupName}/ruleCollectionGroupDrafts/default
 * ```
 */
public class FirewallPolicyRuleCollectionGroupDraft internal constructor(
    override val javaResource: com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraft,
) : KotlinCustomResource(javaResource, FirewallPolicyRuleCollectionGroupDraftMapper) {
    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Priority of the Firewall Policy Rule Collection Group resource.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Group of Firewall Policy rule collections.
     */
    public val ruleCollections:
        Output<List<Either<FirewallPolicyFilterRuleCollectionResponse, FirewallPolicyNatRuleCollectionResponse>>>?
        get() = javaResource.ruleCollections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleCollectionResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleCollectionResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                })
            }).orElse(null)
        })

    /**
     * A read-only string that represents the size of the FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB)
     */
    public val size: Output<String>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * Rule Group type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallPolicyRuleCollectionGroupDraftMapper :
    ResourceMapper<FirewallPolicyRuleCollectionGroupDraft> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraft::class == javaResource::class

    override fun map(javaResource: Resource): FirewallPolicyRuleCollectionGroupDraft =
        FirewallPolicyRuleCollectionGroupDraft(
            javaResource as
                com.pulumi.azurenative.network.FirewallPolicyRuleCollectionGroupDraft,
        )
}

/**
 * @see [FirewallPolicyRuleCollectionGroupDraft].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallPolicyRuleCollectionGroupDraft].
 */
public suspend fun firewallPolicyRuleCollectionGroupDraft(
    name: String,
    block: suspend FirewallPolicyRuleCollectionGroupDraftResourceBuilder.() -> Unit,
): FirewallPolicyRuleCollectionGroupDraft {
    val builder = FirewallPolicyRuleCollectionGroupDraftResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallPolicyRuleCollectionGroupDraft].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallPolicyRuleCollectionGroupDraft(name: String): FirewallPolicyRuleCollectionGroupDraft {
    val builder = FirewallPolicyRuleCollectionGroupDraftResourceBuilder()
    builder.name(name)
    return builder.build()
}
