@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.FlowLogFormatParametersResponse
import com.pulumi.azurenative.network.kotlin.outputs.RetentionPolicyParametersResponse
import com.pulumi.azurenative.network.kotlin.outputs.TrafficAnalyticsPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.FlowLogFormatParametersResponse.Companion.toKotlin as flowLogFormatParametersResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RetentionPolicyParametersResponse.Companion.toKotlin as retentionPolicyParametersResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.TrafficAnalyticsPropertiesResponse.Companion.toKotlin as trafficAnalyticsPropertiesResponseToKotlin

/**
 * Builder for [FlowLog].
 */
@PulumiTagMarker
public class FlowLogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FlowLogArgs = FlowLogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FlowLogArgsBuilder.() -> Unit) {
        val builder = FlowLogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FlowLog {
        val builtJavaResource = com.pulumi.azurenative.network.FlowLog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FlowLog(builtJavaResource)
    }
}

/**
 * A flow log resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create or update flow log
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var flowLog = new AzureNative.Network.FlowLog("flowLog", new()
 *     {
 *         Enabled = true,
 *         FlowLogName = "fl",
 *         Format = new AzureNative.Network.Inputs.FlowLogFormatParametersArgs
 *         {
 *             Type = AzureNative.Network.FlowLogFormatType.JSON,
 *             Version = 1,
 *         },
 *         Location = "centraluseuap",
 *         NetworkWatcherName = "nw1",
 *         ResourceGroupName = "rg1",
 *         StorageId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/nwtest1mgvbfmqsigdxe",
 *         TargetResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/desmondcentral-nsg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFlowLog(ctx, "flowLog", &network.FlowLogArgs{
 * 			Enabled:     pulumi.Bool(true),
 * 			FlowLogName: pulumi.String("fl"),
 * 			Format: &network.FlowLogFormatParametersArgs{
 * 				Type:    pulumi.String(network.FlowLogFormatTypeJSON),
 * 				Version: pulumi.Int(1),
 * 			},
 * 			Location:           pulumi.String("centraluseuap"),
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			StorageId:          pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/nwtest1mgvbfmqsigdxe"),
 * 			TargetResourceId:   pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/desmondcentral-nsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FlowLog;
 * import com.pulumi.azurenative.network.FlowLogArgs;
 * import com.pulumi.azurenative.network.inputs.FlowLogFormatParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var flowLog = new FlowLog("flowLog", FlowLogArgs.builder()
 *             .enabled(true)
 *             .flowLogName("fl")
 *             .format(FlowLogFormatParametersArgs.builder()
 *                 .type("JSON")
 *                 .version(1)
 *                 .build())
 *             .location("centraluseuap")
 *             .networkWatcherName("nw1")
 *             .resourceGroupName("rg1")
 *             .storageId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/nwtest1mgvbfmqsigdxe")
 *             .targetResourceId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/desmondcentral-nsg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FlowLog Microsoft.Networkdesmond-rgdesmondcentral-nsg /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}
 * ```
 */
public class FlowLog internal constructor(
    override val javaResource: com.pulumi.azurenative.network.FlowLog,
) : KotlinCustomResource(javaResource, FlowLogMapper) {
    /**
     * Flag to enable/disable flow logging.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Parameters that define the configuration of traffic analytics.
     */
    public val flowAnalyticsConfiguration: Output<TrafficAnalyticsPropertiesResponse>?
        get() = javaResource.flowAnalyticsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> trafficAnalyticsPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Parameters that define the flow log format.
     */
    public val format: Output<FlowLogFormatParametersResponse>?
        get() = javaResource.format().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    flowLogFormatParametersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the flow log.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Parameters that define the retention policy for flow log.
     */
    public val retentionPolicy: Output<RetentionPolicyParametersResponse>?
        get() = javaResource.retentionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> retentionPolicyParametersResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ID of the storage account which is used to store the flow log.
     */
    public val storageId: Output<String>
        get() = javaResource.storageId().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Guid of network security group to which flow log will be applied.
     */
    public val targetResourceGuid: Output<String>
        get() = javaResource.targetResourceGuid().applyValue({ args0 -> args0 })

    /**
     * ID of network security group to which flow log will be applied.
     */
    public val targetResourceId: Output<String>
        get() = javaResource.targetResourceId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FlowLogMapper : ResourceMapper<FlowLog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.FlowLog::class == javaResource::class

    override fun map(javaResource: Resource): FlowLog = FlowLog(
        javaResource as
            com.pulumi.azurenative.network.FlowLog,
    )
}

/**
 * @see [FlowLog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FlowLog].
 */
public suspend fun flowLog(name: String, block: suspend FlowLogResourceBuilder.() -> Unit): FlowLog {
    val builder = FlowLogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FlowLog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun flowLog(name: String): FlowLog {
    val builder = FlowLogResourceBuilder()
    builder.name(name)
    return builder.build()
}
