@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.FlowLogArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.FlowLogFormatParametersArgs
import com.pulumi.azurenative.network.kotlin.inputs.FlowLogFormatParametersArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.RetentionPolicyParametersArgs
import com.pulumi.azurenative.network.kotlin.inputs.RetentionPolicyParametersArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.TrafficAnalyticsPropertiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.TrafficAnalyticsPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A flow log resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create or update flow log
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var flowLog = new AzureNative.Network.FlowLog("flowLog", new()
 *     {
 *         Enabled = true,
 *         FlowLogName = "fl",
 *         Format = new AzureNative.Network.Inputs.FlowLogFormatParametersArgs
 *         {
 *             Type = AzureNative.Network.FlowLogFormatType.JSON,
 *             Version = 1,
 *         },
 *         Location = "centraluseuap",
 *         NetworkWatcherName = "nw1",
 *         ResourceGroupName = "rg1",
 *         StorageId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/nwtest1mgvbfmqsigdxe",
 *         TargetResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/desmondcentral-nsg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFlowLog(ctx, "flowLog", &network.FlowLogArgs{
 * 			Enabled:     pulumi.Bool(true),
 * 			FlowLogName: pulumi.String("fl"),
 * 			Format: &network.FlowLogFormatParametersArgs{
 * 				Type:    pulumi.String(network.FlowLogFormatTypeJSON),
 * 				Version: pulumi.Int(1),
 * 			},
 * 			Location:           pulumi.String("centraluseuap"),
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			StorageId:          pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/nwtest1mgvbfmqsigdxe"),
 * 			TargetResourceId:   pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/desmondcentral-nsg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FlowLog;
 * import com.pulumi.azurenative.network.FlowLogArgs;
 * import com.pulumi.azurenative.network.inputs.FlowLogFormatParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var flowLog = new FlowLog("flowLog", FlowLogArgs.builder()
 *             .enabled(true)
 *             .flowLogName("fl")
 *             .format(FlowLogFormatParametersArgs.builder()
 *                 .type("JSON")
 *                 .version(1)
 *                 .build())
 *             .location("centraluseuap")
 *             .networkWatcherName("nw1")
 *             .resourceGroupName("rg1")
 *             .storageId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/nwtest1mgvbfmqsigdxe")
 *             .targetResourceId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/desmondcentral-nsg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FlowLog Microsoft.Networkdesmond-rgdesmondcentral-nsg /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}
 * ```
 * @property enabled Flag to enable/disable flow logging.
 * @property flowAnalyticsConfiguration Parameters that define the configuration of traffic analytics.
 * @property flowLogName The name of the flow log.
 * @property format Parameters that define the flow log format.
 * @property id Resource ID.
 * @property location Resource location.
 * @property networkWatcherName The name of the network watcher.
 * @property resourceGroupName The name of the resource group.
 * @property retentionPolicy Parameters that define the retention policy for flow log.
 * @property storageId ID of the storage account which is used to store the flow log.
 * @property tags Resource tags.
 * @property targetResourceId ID of network security group to which flow log will be applied.
 */
public data class FlowLogArgs(
    public val enabled: Output<Boolean>? = null,
    public val flowAnalyticsConfiguration: Output<TrafficAnalyticsPropertiesArgs>? = null,
    public val flowLogName: Output<String>? = null,
    public val format: Output<FlowLogFormatParametersArgs>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkWatcherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionPolicy: Output<RetentionPolicyParametersArgs>? = null,
    public val storageId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.FlowLogArgs> {
    override fun toJava(): com.pulumi.azurenative.network.FlowLogArgs =
        com.pulumi.azurenative.network.FlowLogArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .flowAnalyticsConfiguration(
                flowAnalyticsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .flowLogName(flowLogName?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkWatcherName(networkWatcherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionPolicy(retentionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageId(storageId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceId(targetResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowLogArgs].
 */
@PulumiTagMarker
public class FlowLogArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var flowAnalyticsConfiguration: Output<TrafficAnalyticsPropertiesArgs>? = null

    private var flowLogName: Output<String>? = null

    private var format: Output<FlowLogFormatParametersArgs>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var networkWatcherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionPolicy: Output<RetentionPolicyParametersArgs>? = null

    private var storageId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceId: Output<String>? = null

    /**
     * @param value Flag to enable/disable flow logging.
     */
    @JvmName("jjhcdveupyfqsrcp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Parameters that define the configuration of traffic analytics.
     */
    @JvmName("lqqwupsrumbacdjb")
    public suspend fun flowAnalyticsConfiguration(`value`: Output<TrafficAnalyticsPropertiesArgs>) {
        this.flowAnalyticsConfiguration = value
    }

    /**
     * @param value The name of the flow log.
     */
    @JvmName("jphxuglhafsycwfg")
    public suspend fun flowLogName(`value`: Output<String>) {
        this.flowLogName = value
    }

    /**
     * @param value Parameters that define the flow log format.
     */
    @JvmName("oucsfdswcoppyafl")
    public suspend fun format(`value`: Output<FlowLogFormatParametersArgs>) {
        this.format = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yhuccyyedxqqrhxy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gsvrrwbpqvfnyewy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("mtbuuhiyfofmrkpy")
    public suspend fun networkWatcherName(`value`: Output<String>) {
        this.networkWatcherName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uqsoovalaxxclwcs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameters that define the retention policy for flow log.
     */
    @JvmName("mtwwndvropwlbrua")
    public suspend fun retentionPolicy(`value`: Output<RetentionPolicyParametersArgs>) {
        this.retentionPolicy = value
    }

    /**
     * @param value ID of the storage account which is used to store the flow log.
     */
    @JvmName("fevwmgxdmehetjkl")
    public suspend fun storageId(`value`: Output<String>) {
        this.storageId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wkumjjcthcovfohc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of network security group to which flow log will be applied.
     */
    @JvmName("wnfqkwkxemkaqbnc")
    public suspend fun targetResourceId(`value`: Output<String>) {
        this.targetResourceId = value
    }

    /**
     * @param value Flag to enable/disable flow logging.
     */
    @JvmName("mgfpygmgmkhbxonr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Parameters that define the configuration of traffic analytics.
     */
    @JvmName("ocftysexewrprnyd")
    public suspend fun flowAnalyticsConfiguration(`value`: TrafficAnalyticsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowAnalyticsConfiguration = mapped
    }

    /**
     * @param argument Parameters that define the configuration of traffic analytics.
     */
    @JvmName("tgrdecfivnirfucj")
    public suspend fun flowAnalyticsConfiguration(argument: suspend TrafficAnalyticsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TrafficAnalyticsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.flowAnalyticsConfiguration = mapped
    }

    /**
     * @param value The name of the flow log.
     */
    @JvmName("hanfeavlmybepqhp")
    public suspend fun flowLogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowLogName = mapped
    }

    /**
     * @param value Parameters that define the flow log format.
     */
    @JvmName("bhmbcqcffhiwrfya")
    public suspend fun format(`value`: FlowLogFormatParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param argument Parameters that define the flow log format.
     */
    @JvmName("duxmqacpxiffomey")
    public suspend fun format(argument: suspend FlowLogFormatParametersArgsBuilder.() -> Unit) {
        val toBeMapped = FlowLogFormatParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.format = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bmlslrruweughtlw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("yrfpiqnhrksehaqq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("gnjwcxapelfbilnl")
    public suspend fun networkWatcherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkWatcherName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("esqvchdkmgctmnrh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameters that define the retention policy for flow log.
     */
    @JvmName("brqcrxeihqulrtfw")
    public suspend fun retentionPolicy(`value`: RetentionPolicyParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param argument Parameters that define the retention policy for flow log.
     */
    @JvmName("ybapitatnupnwfno")
    public suspend fun retentionPolicy(argument: suspend RetentionPolicyParametersArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionPolicyParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPolicy = mapped
    }

    /**
     * @param value ID of the storage account which is used to store the flow log.
     */
    @JvmName("daxdhlytitjdpipb")
    public suspend fun storageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xlknaweoigvgqdbx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tgmraqhlgrvybqjy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ID of network security group to which flow log will be applied.
     */
    @JvmName("qtpjambrphsjvlec")
    public suspend fun targetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceId = mapped
    }

    internal fun build(): FlowLogArgs = FlowLogArgs(
        enabled = enabled,
        flowAnalyticsConfiguration = flowAnalyticsConfiguration,
        flowLogName = flowLogName,
        format = format,
        id = id,
        location = location,
        networkWatcherName = networkWatcherName,
        resourceGroupName = resourceGroupName,
        retentionPolicy = retentionPolicy,
        storageId = storageId,
        tags = tags,
        targetResourceId = targetResourceId,
    )
}
