@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ForwardingRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ForwardingRuleState
import com.pulumi.azurenative.network.kotlin.inputs.TargetDnsServerArgs
import com.pulumi.azurenative.network.kotlin.inputs.TargetDnsServerArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a forwarding rule within a DNS forwarding ruleset.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert forwarding rule in a DNS forwarding ruleset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var forwardingRule = new AzureNative.Network.ForwardingRule("forwardingRule", new()
 *     {
 *         DnsForwardingRulesetName = "sampleDnsForwardingRuleset",
 *         DomainName = "contoso.com.",
 *         ForwardingRuleName = "sampleForwardingRule",
 *         ForwardingRuleState = AzureNative.Network.ForwardingRuleState.Enabled,
 *         Metadata =
 *         {
 *             { "additionalProp1", "value1" },
 *         },
 *         ResourceGroupName = "sampleResourceGroup",
 *         TargetDnsServers = new[]
 *         {
 *             new AzureNative.Network.Inputs.TargetDnsServerArgs
 *             {
 *                 IpAddress = "10.0.0.1",
 *                 Port = 53,
 *             },
 *             new AzureNative.Network.Inputs.TargetDnsServerArgs
 *             {
 *                 IpAddress = "10.0.0.2",
 *                 Port = 53,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewForwardingRule(ctx, "forwardingRule", &network.ForwardingRuleArgs{
 * 			DnsForwardingRulesetName: pulumi.String("sampleDnsForwardingRuleset"),
 * 			DomainName:               pulumi.String("contoso.com."),
 * 			ForwardingRuleName:       pulumi.String("sampleForwardingRule"),
 * 			ForwardingRuleState:      pulumi.String(network.ForwardingRuleStateEnabled),
 * 			Metadata: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("value1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			TargetDnsServers: network.TargetDnsServerArray{
 * 				&network.TargetDnsServerArgs{
 * 					IpAddress: pulumi.String("10.0.0.1"),
 * 					Port:      pulumi.Int(53),
 * 				},
 * 				&network.TargetDnsServerArgs{
 * 					IpAddress: pulumi.String("10.0.0.2"),
 * 					Port:      pulumi.Int(53),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ForwardingRule;
 * import com.pulumi.azurenative.network.ForwardingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.TargetDnsServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var forwardingRule = new ForwardingRule("forwardingRule", ForwardingRuleArgs.builder()
 *             .dnsForwardingRulesetName("sampleDnsForwardingRuleset")
 *             .domainName("contoso.com.")
 *             .forwardingRuleName("sampleForwardingRule")
 *             .forwardingRuleState("Enabled")
 *             .metadata(Map.of("additionalProp1", "value1"))
 *             .resourceGroupName("sampleResourceGroup")
 *             .targetDnsServers(
 *                 TargetDnsServerArgs.builder()
 *                     .ipAddress("10.0.0.1")
 *                     .port(53)
 *                     .build(),
 *                 TargetDnsServerArgs.builder()
 *                     .ipAddress("10.0.0.2")
 *                     .port(53)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ForwardingRule sampleForwardingRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}
 * ```
 * @property dnsForwardingRulesetName The name of the DNS forwarding ruleset.
 * @property domainName The domain name for the forwarding rule.
 * @property forwardingRuleName The name of the forwarding rule.
 * @property forwardingRuleState The state of forwarding rule.
 * @property metadata Metadata attached to the forwarding rule.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property targetDnsServers DNS servers to forward the DNS query to.
 */
public data class ForwardingRuleArgs(
    public val dnsForwardingRulesetName: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val forwardingRuleName: Output<String>? = null,
    public val forwardingRuleState: Output<Either<String, ForwardingRuleState>>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val targetDnsServers: Output<List<TargetDnsServerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ForwardingRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ForwardingRuleArgs =
        com.pulumi.azurenative.network.ForwardingRuleArgs.builder()
            .dnsForwardingRulesetName(dnsForwardingRulesetName?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .forwardingRuleName(forwardingRuleName?.applyValue({ args0 -> args0 }))
            .forwardingRuleState(
                forwardingRuleState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .targetDnsServers(
                targetDnsServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ForwardingRuleArgs].
 */
@PulumiTagMarker
public class ForwardingRuleArgsBuilder internal constructor() {
    private var dnsForwardingRulesetName: Output<String>? = null

    private var domainName: Output<String>? = null

    private var forwardingRuleName: Output<String>? = null

    private var forwardingRuleState: Output<Either<String, ForwardingRuleState>>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var targetDnsServers: Output<List<TargetDnsServerArgs>>? = null

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("wwwnyccghytlicww")
    public suspend fun dnsForwardingRulesetName(`value`: Output<String>) {
        this.dnsForwardingRulesetName = value
    }

    /**
     * @param value The domain name for the forwarding rule.
     */
    @JvmName("levcnqrjiqdgevpf")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of the forwarding rule.
     */
    @JvmName("mxljxafdkxsdcoct")
    public suspend fun forwardingRuleName(`value`: Output<String>) {
        this.forwardingRuleName = value
    }

    /**
     * @param value The state of forwarding rule.
     */
    @JvmName("eqcyxbjgcgudxkjl")
    public suspend fun forwardingRuleState(`value`: Output<Either<String, ForwardingRuleState>>) {
        this.forwardingRuleState = value
    }

    /**
     * @param value Metadata attached to the forwarding rule.
     */
    @JvmName("uhkbvvaackqptxky")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("itmaavleijjciaio")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value DNS servers to forward the DNS query to.
     */
    @JvmName("sovpbvvoafmkphiv")
    public suspend fun targetDnsServers(`value`: Output<List<TargetDnsServerArgs>>) {
        this.targetDnsServers = value
    }

    @JvmName("xtjydsviofttneyk")
    public suspend fun targetDnsServers(vararg values: Output<TargetDnsServerArgs>) {
        this.targetDnsServers = Output.all(values.asList())
    }

    /**
     * @param values DNS servers to forward the DNS query to.
     */
    @JvmName("hycaibtbriavpyby")
    public suspend fun targetDnsServers(values: List<Output<TargetDnsServerArgs>>) {
        this.targetDnsServers = Output.all(values)
    }

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("qappfgklpyhitfjc")
    public suspend fun dnsForwardingRulesetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsForwardingRulesetName = mapped
    }

    /**
     * @param value The domain name for the forwarding rule.
     */
    @JvmName("isubixbpchjcfxdy")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The name of the forwarding rule.
     */
    @JvmName("psbfgdmorgnlhevs")
    public suspend fun forwardingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardingRuleName = mapped
    }

    /**
     * @param value The state of forwarding rule.
     */
    @JvmName("motacbwgopmiwakr")
    public suspend fun forwardingRuleState(`value`: Either<String, ForwardingRuleState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardingRuleState = mapped
    }

    /**
     * @param value The state of forwarding rule.
     */
    @JvmName("lrlolciclqsggtcm")
    public fun forwardingRuleState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ForwardingRuleState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardingRuleState = mapped
    }

    /**
     * @param value The state of forwarding rule.
     */
    @JvmName("sqsmtvjswihfwmhf")
    public fun forwardingRuleState(`value`: ForwardingRuleState) {
        val toBeMapped = Either.ofRight<String, ForwardingRuleState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardingRuleState = mapped
    }

    /**
     * @param value Metadata attached to the forwarding rule.
     */
    @JvmName("myvcxduwyikuwvmx")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values Metadata attached to the forwarding rule.
     */
    @JvmName("utmvhbkwkdaxxqll")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fphwgbdnpsaiawho")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value DNS servers to forward the DNS query to.
     */
    @JvmName("rraqejumtvebnpxi")
    public suspend fun targetDnsServers(`value`: List<TargetDnsServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDnsServers = mapped
    }

    /**
     * @param argument DNS servers to forward the DNS query to.
     */
    @JvmName("kbelnvpmwfocfqfh")
    public suspend fun targetDnsServers(argument: List<suspend TargetDnsServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetDnsServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetDnsServers = mapped
    }

    /**
     * @param argument DNS servers to forward the DNS query to.
     */
    @JvmName("kybbkveoqvsuctpl")
    public suspend fun targetDnsServers(vararg argument: suspend TargetDnsServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TargetDnsServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetDnsServers = mapped
    }

    /**
     * @param argument DNS servers to forward the DNS query to.
     */
    @JvmName("cykhttaurvsfmthh")
    public suspend fun targetDnsServers(argument: suspend TargetDnsServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetDnsServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetDnsServers = mapped
    }

    /**
     * @param values DNS servers to forward the DNS query to.
     */
    @JvmName("kmpqpfstlyewsflb")
    public suspend fun targetDnsServers(vararg values: TargetDnsServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetDnsServers = mapped
    }

    internal fun build(): ForwardingRuleArgs = ForwardingRuleArgs(
        dnsForwardingRulesetName = dnsForwardingRulesetName,
        domainName = domainName,
        forwardingRuleName = forwardingRuleName,
        forwardingRuleState = forwardingRuleState,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        targetDnsServers = targetDnsServers,
    )
}
