@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.FrontDoorArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorEnabledState
import com.pulumi.azurenative.network.kotlin.inputs.BackendPoolArgs
import com.pulumi.azurenative.network.kotlin.inputs.BackendPoolArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.BackendPoolsSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.BackendPoolsSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FrontendEndpointArgs
import com.pulumi.azurenative.network.kotlin.inputs.FrontendEndpointArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.HealthProbeSettingsModelArgs
import com.pulumi.azurenative.network.kotlin.inputs.HealthProbeSettingsModelArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancingSettingsModelArgs
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancingSettingsModelArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.RoutingRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.RoutingRuleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Front Door represents a collection of backend endpoints to route traffic to along with rules that specify how traffic is sent there.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create or update specific Front Door
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var frontDoor = new AzureNative.Network.FrontDoor("frontDoor", new()
 *     {
 *         BackendPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendPoolArgs
 *             {
 *                 Backends = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "w3.contoso.com",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 2,
 *                         Weight = 1,
 *                     },
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "contoso.com.website-us-west-2.othercloud.net",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 1,
 *                         PrivateLinkApprovalMessage = "Please approve the connection request for this Private Link",
 *                         PrivateLinkLocation = "eastus",
 *                         PrivateLinkResourceId = "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1",
 *                         Weight = 2,
 *                     },
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "10.0.1.5",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 1,
 *                         PrivateLinkAlias = "APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice",
 *                         PrivateLinkApprovalMessage = "Please approve this request to connect to the Private Link",
 *                         Weight = 1,
 *                     },
 *                 },
 *                 HealthProbeSettings = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1",
 *                 },
 *                 LoadBalancingSettings = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1",
 *                 },
 *                 Name = "backendPool1",
 *             },
 *         },
 *         BackendPoolsSettings = new AzureNative.Network.Inputs.BackendPoolsSettingsArgs
 *         {
 *             EnforceCertificateNameCheck = AzureNative.Network.EnforceCertificateNameCheckEnabledState.Enabled,
 *             SendRecvTimeoutSeconds = 60,
 *         },
 *         EnabledState = AzureNative.Network.FrontDoorEnabledState.Enabled,
 *         FrontDoorName = "frontDoor1",
 *         FrontendEndpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendEndpointArgs
 *             {
 *                 HostName = "www.contoso.com",
 *                 Name = "frontendEndpoint1",
 *                 SessionAffinityEnabledState = AzureNative.Network.SessionAffinityEnabledState.Enabled,
 *                 SessionAffinityTtlSeconds = 60,
 *                 WebApplicationFirewallPolicyLink = new AzureNative.Network.Inputs.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1",
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.FrontendEndpointArgs
 *             {
 *                 HostName = "frontDoor1.azurefd.net",
 *                 Name = "default",
 *             },
 *         },
 *         HealthProbeSettings = new[]
 *         {
 *             new AzureNative.Network.Inputs.HealthProbeSettingsModelArgs
 *             {
 *                 EnabledState = AzureNative.Network.HealthProbeEnabled.Enabled,
 *                 HealthProbeMethod = AzureNative.Network.FrontDoorHealthProbeMethod.HEAD,
 *                 IntervalInSeconds = 120,
 *                 Name = "healthProbeSettings1",
 *                 Path = "/",
 *                 Protocol = AzureNative.Network.FrontDoorProtocol.Http,
 *             },
 *         },
 *         LoadBalancingSettings = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingSettingsModelArgs
 *             {
 *                 Name = "loadBalancingSettings1",
 *                 SampleSize = 4,
 *                 SuccessfulSamplesRequired = 2,
 *             },
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         RoutingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RoutingRuleArgs
 *             {
 *                 AcceptedProtocols = new[]
 *                 {
 *                     AzureNative.Network.FrontDoorProtocol.Http,
 *                 },
 *                 EnabledState = AzureNative.Network.RoutingRuleEnabledState.Enabled,
 *                 FrontendEndpoints = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default",
 *                     },
 *                 },
 *                 Name = "routingRule1",
 *                 PatternsToMatch = new[]
 *                 {
 *                     "/*",
 *                 },
 *                 RouteConfiguration = new AzureNative.Network.Inputs.ForwardingConfigurationArgs
 *                 {
 *                     BackendPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 *                     },
 *                     OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 *                 },
 *                 RulesEngine = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1",
 *                 },
 *                 WebApplicationFirewallPolicyLink = new AzureNative.Network.Inputs.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFrontDoor(ctx, "frontDoor", &network.FrontDoorArgs{
 * 			BackendPools: network.BackendPoolArray{
 * 				&network.BackendPoolArgs{
 * 					Backends: network.BackendArray{
 * 						&network.BackendArgs{
 * 							Address:   pulumi.String("w3.contoso.com"),
 * 							HttpPort:  pulumi.Int(80),
 * 							HttpsPort: pulumi.Int(443),
 * 							Priority:  pulumi.Int(2),
 * 							Weight:    pulumi.Int(1),
 * 						},
 * 						&network.BackendArgs{
 * 							Address:                    pulumi.String("contoso.com.website-us-west-2.othercloud.net"),
 * 							HttpPort:                   pulumi.Int(80),
 * 							HttpsPort:                  pulumi.Int(443),
 * 							Priority:                   pulumi.Int(1),
 * 							PrivateLinkApprovalMessage: pulumi.String("Please approve the connection request for this Private Link"),
 * 							PrivateLinkLocation:        pulumi.String("eastus"),
 * 							PrivateLinkResourceId:      pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1"),
 * 							Weight:                     pulumi.Int(2),
 * 						},
 * 						&network.BackendArgs{
 * 							Address:                    pulumi.String("10.0.1.5"),
 * 							HttpPort:                   pulumi.Int(80),
 * 							HttpsPort:                  pulumi.Int(443),
 * 							Priority:                   pulumi.Int(1),
 * 							PrivateLinkAlias:           pulumi.String("APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice"),
 * 							PrivateLinkApprovalMessage: pulumi.String("Please approve this request to connect to the Private Link"),
 * 							Weight:                     pulumi.Int(1),
 * 						},
 * 					},
 * 					HealthProbeSettings: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1"),
 * 					},
 * 					LoadBalancingSettings: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1"),
 * 					},
 * 					Name: pulumi.String("backendPool1"),
 * 				},
 * 			},
 * 			BackendPoolsSettings: &network.BackendPoolsSettingsArgs{
 * 				EnforceCertificateNameCheck: pulumi.String(network.EnforceCertificateNameCheckEnabledStateEnabled),
 * 				SendRecvTimeoutSeconds:      pulumi.Int(60),
 * 			},
 * 			EnabledState:  pulumi.String(network.FrontDoorEnabledStateEnabled),
 * 			FrontDoorName: pulumi.String("frontDoor1"),
 * 			FrontendEndpoints: network.FrontendEndpointArray{
 * 				&network.FrontendEndpointArgs{
 * 					HostName:                    pulumi.String("www.contoso.com"),
 * 					Name:                        pulumi.String("frontendEndpoint1"),
 * 					SessionAffinityEnabledState: pulumi.String(network.SessionAffinityEnabledStateEnabled),
 * 					SessionAffinityTtlSeconds:   pulumi.Int(60),
 * 					WebApplicationFirewallPolicyLink: &network.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"),
 * 					},
 * 				},
 * 				&network.FrontendEndpointArgs{
 * 					HostName: pulumi.String("frontDoor1.azurefd.net"),
 * 					Name:     pulumi.String("default"),
 * 				},
 * 			},
 * 			HealthProbeSettings: network.HealthProbeSettingsModelArray{
 * 				&network.HealthProbeSettingsModelArgs{
 * 					EnabledState:      pulumi.String(network.HealthProbeEnabledEnabled),
 * 					HealthProbeMethod: pulumi.String(network.FrontDoorHealthProbeMethodHEAD),
 * 					IntervalInSeconds: pulumi.Int(120),
 * 					Name:              pulumi.String("healthProbeSettings1"),
 * 					Path:              pulumi.String("/"),
 * 					Protocol:          pulumi.String(network.FrontDoorProtocolHttp),
 * 				},
 * 			},
 * 			LoadBalancingSettings: network.LoadBalancingSettingsModelArray{
 * 				&network.LoadBalancingSettingsModelArgs{
 * 					Name:                      pulumi.String("loadBalancingSettings1"),
 * 					SampleSize:                pulumi.Int(4),
 * 					SuccessfulSamplesRequired: pulumi.Int(2),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RoutingRules: network.RoutingRuleArray{
 * 				&network.RoutingRuleArgs{
 * 					AcceptedProtocols: pulumi.StringArray{
 * 						pulumi.String(network.FrontDoorProtocolHttp),
 * 					},
 * 					EnabledState: pulumi.String(network.RoutingRuleEnabledStateEnabled),
 * 					FrontendEndpoints: network.SubResourceArray{
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1"),
 * 						},
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default"),
 * 						},
 * 					},
 * 					Name: pulumi.String("routingRule1"),
 * 					PatternsToMatch: pulumi.StringArray{
 * 						pulumi.String("/*"),
 * 					},
 * 					RouteConfiguration: network.ForwardingConfiguration{
 * 						BackendPool: network.SubResource{
 * 							Id: "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 * 						},
 * 						OdataType: "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 * 					},
 * 					RulesEngine: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1"),
 * 					},
 * 					WebApplicationFirewallPolicyLink: &network.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FrontDoor;
 * import com.pulumi.azurenative.network.FrontDoorArgs;
 * import com.pulumi.azurenative.network.inputs.BackendPoolArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.BackendPoolsSettingsArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendEndpointArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs;
 * import com.pulumi.azurenative.network.inputs.HealthProbeSettingsModelArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingSettingsModelArgs;
 * import com.pulumi.azurenative.network.inputs.RoutingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontDoor = new FrontDoor("frontDoor", FrontDoorArgs.builder()
 *             .backendPools(BackendPoolArgs.builder()
 *                 .backends(
 *                     BackendArgs.builder()
 *                         .address("w3.contoso.com")
 *                         .httpPort(80)
 *                         .httpsPort(443)
 *                         .priority(2)
 *                         .weight(1)
 *                         .build(),
 *                     BackendArgs.builder()
 *                         .address("contoso.com.website-us-west-2.othercloud.net")
 *                         .httpPort(80)
 *                         .httpsPort(443)
 *                         .priority(1)
 *                         .privateLinkApprovalMessage("Please approve the connection request for this Private Link")
 *                         .privateLinkLocation("eastus")
 *                         .privateLinkResourceId("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1")
 *                         .weight(2)
 *                         .build(),
 *                     BackendArgs.builder()
 *                         .address("10.0.1.5")
 *                         .httpPort(80)
 *                         .httpsPort(443)
 *                         .priority(1)
 *                         .privateLinkAlias("APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice")
 *                         .privateLinkApprovalMessage("Please approve this request to connect to the Private Link")
 *                         .weight(1)
 *                         .build())
 *                 .healthProbeSettings(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1")
 *                     .build())
 *                 .loadBalancingSettings(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1")
 *                     .build())
 *                 .name("backendPool1")
 *                 .build())
 *             .backendPoolsSettings(BackendPoolsSettingsArgs.builder()
 *                 .enforceCertificateNameCheck("Enabled")
 *                 .sendRecvTimeoutSeconds(60)
 *                 .build())
 *             .enabledState("Enabled")
 *             .frontDoorName("frontDoor1")
 *             .frontendEndpoints(
 *                 FrontendEndpointArgs.builder()
 *                     .hostName("www.contoso.com")
 *                     .name("frontendEndpoint1")
 *                     .sessionAffinityEnabledState("Enabled")
 *                     .sessionAffinityTtlSeconds(60)
 *                     .webApplicationFirewallPolicyLink(FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1")
 *                         .build())
 *                     .build(),
 *                 FrontendEndpointArgs.builder()
 *                     .hostName("frontDoor1.azurefd.net")
 *                     .name("default")
 *                     .build())
 *             .healthProbeSettings(HealthProbeSettingsModelArgs.builder()
 *                 .enabledState("Enabled")
 *                 .healthProbeMethod("HEAD")
 *                 .intervalInSeconds(120)
 *                 .name("healthProbeSettings1")
 *                 .path("/")
 *                 .protocol("Http")
 *                 .build())
 *             .loadBalancingSettings(LoadBalancingSettingsModelArgs.builder()
 *                 .name("loadBalancingSettings1")
 *                 .sampleSize(4)
 *                 .successfulSamplesRequired(2)
 *                 .build())
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .routingRules(RoutingRuleArgs.builder()
 *                 .acceptedProtocols("Http")
 *                 .enabledState("Enabled")
 *                 .frontendEndpoints(
 *                     SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1")
 *                         .build(),
 *                     SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default")
 *                         .build())
 *                 .name("routingRule1")
 *                 .patternsToMatch("/*")
 *                 .routeConfiguration(ForwardingConfigurationArgs.builder()
 *                     .backendPool(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1")
 *                         .build())
 *                     .odataType("#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration")
 *                     .build())
 *                 .rulesEngine(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1")
 *                     .build())
 *                 .webApplicationFirewallPolicyLink(RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1")
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FrontDoor frontDoor1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}
 * ```
 * @property backendPools Backend pools available to routing rules.
 * @property backendPoolsSettings Settings for all backendPools
 * @property enabledState Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
 * @property friendlyName A friendly name for the frontDoor
 * @property frontDoorName Name of the Front Door which is globally unique.
 * @property frontendEndpoints Frontend endpoints available to routing rules.
 * @property healthProbeSettings Health probe settings associated with this Front Door instance.
 * @property loadBalancingSettings Load balancing settings associated with this Front Door instance.
 * @property location Resource location.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property routingRules Routing rules associated with this Front Door.
 * @property tags Resource tags.
 * */*/*/
 */
public data class FrontDoorArgs(
    public val backendPools: Output<List<BackendPoolArgs>>? = null,
    public val backendPoolsSettings: Output<BackendPoolsSettingsArgs>? = null,
    public val enabledState: Output<Either<String, FrontDoorEnabledState>>? = null,
    public val friendlyName: Output<String>? = null,
    public val frontDoorName: Output<String>? = null,
    public val frontendEndpoints: Output<List<FrontendEndpointArgs>>? = null,
    public val healthProbeSettings: Output<List<HealthProbeSettingsModelArgs>>? = null,
    public val loadBalancingSettings: Output<List<LoadBalancingSettingsModelArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingRules: Output<List<RoutingRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.FrontDoorArgs> {
    override fun toJava(): com.pulumi.azurenative.network.FrontDoorArgs =
        com.pulumi.azurenative.network.FrontDoorArgs.builder()
            .backendPools(
                backendPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .backendPoolsSettings(
                backendPoolsSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .frontDoorName(frontDoorName?.applyValue({ args0 -> args0 }))
            .frontendEndpoints(
                frontendEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .healthProbeSettings(
                healthProbeSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loadBalancingSettings(
                loadBalancingSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingRules(
                routingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FrontDoorArgs].
 */
@PulumiTagMarker
public class FrontDoorArgsBuilder internal constructor() {
    private var backendPools: Output<List<BackendPoolArgs>>? = null

    private var backendPoolsSettings: Output<BackendPoolsSettingsArgs>? = null

    private var enabledState: Output<Either<String, FrontDoorEnabledState>>? = null

    private var friendlyName: Output<String>? = null

    private var frontDoorName: Output<String>? = null

    private var frontendEndpoints: Output<List<FrontendEndpointArgs>>? = null

    private var healthProbeSettings: Output<List<HealthProbeSettingsModelArgs>>? = null

    private var loadBalancingSettings: Output<List<LoadBalancingSettingsModelArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingRules: Output<List<RoutingRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Backend pools available to routing rules.
     */
    @JvmName("gqpqqiejumsqodiw")
    public suspend fun backendPools(`value`: Output<List<BackendPoolArgs>>) {
        this.backendPools = value
    }

    @JvmName("yspniybqsoxmymao")
    public suspend fun backendPools(vararg values: Output<BackendPoolArgs>) {
        this.backendPools = Output.all(values.asList())
    }

    /**
     * @param values Backend pools available to routing rules.
     */
    @JvmName("oifrxfdcmbjqekgv")
    public suspend fun backendPools(values: List<Output<BackendPoolArgs>>) {
        this.backendPools = Output.all(values)
    }

    /**
     * @param value Settings for all backendPools
     */
    @JvmName("cmbmjijehobhwimw")
    public suspend fun backendPoolsSettings(`value`: Output<BackendPoolsSettingsArgs>) {
        this.backendPoolsSettings = value
    }

    /**
     * @param value Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("opsitlrdjjkayckn")
    public suspend fun enabledState(`value`: Output<Either<String, FrontDoorEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value A friendly name for the frontDoor
     */
    @JvmName("rfrtqbndeqswimyp")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("brndqrmbgrinynmi")
    public suspend fun frontDoorName(`value`: Output<String>) {
        this.frontDoorName = value
    }

    /**
     * @param value Frontend endpoints available to routing rules.
     */
    @JvmName("nhnxeosunmhbpysw")
    public suspend fun frontendEndpoints(`value`: Output<List<FrontendEndpointArgs>>) {
        this.frontendEndpoints = value
    }

    @JvmName("saabetyjvlkqokhm")
    public suspend fun frontendEndpoints(vararg values: Output<FrontendEndpointArgs>) {
        this.frontendEndpoints = Output.all(values.asList())
    }

    /**
     * @param values Frontend endpoints available to routing rules.
     */
    @JvmName("bwhhrxoagvxahvhw")
    public suspend fun frontendEndpoints(values: List<Output<FrontendEndpointArgs>>) {
        this.frontendEndpoints = Output.all(values)
    }

    /**
     * @param value Health probe settings associated with this Front Door instance.
     */
    @JvmName("proihekbefgdhxcd")
    public suspend fun healthProbeSettings(`value`: Output<List<HealthProbeSettingsModelArgs>>) {
        this.healthProbeSettings = value
    }

    @JvmName("qqqufikaofdnfgou")
    public suspend fun healthProbeSettings(vararg values: Output<HealthProbeSettingsModelArgs>) {
        this.healthProbeSettings = Output.all(values.asList())
    }

    /**
     * @param values Health probe settings associated with this Front Door instance.
     */
    @JvmName("ntnjmdbmqwdyrytk")
    public suspend fun healthProbeSettings(values: List<Output<HealthProbeSettingsModelArgs>>) {
        this.healthProbeSettings = Output.all(values)
    }

    /**
     * @param value Load balancing settings associated with this Front Door instance.
     */
    @JvmName("ggcnrfxfktwctluc")
    public suspend fun loadBalancingSettings(`value`: Output<List<LoadBalancingSettingsModelArgs>>) {
        this.loadBalancingSettings = value
    }

    @JvmName("hihhnywwrddagjsx")
    public suspend fun loadBalancingSettings(vararg values: Output<LoadBalancingSettingsModelArgs>) {
        this.loadBalancingSettings = Output.all(values.asList())
    }

    /**
     * @param values Load balancing settings associated with this Front Door instance.
     */
    @JvmName("loeaikfvecnouseu")
    public suspend fun loadBalancingSettings(values: List<Output<LoadBalancingSettingsModelArgs>>) {
        this.loadBalancingSettings = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("eumpqhxdomcqgihs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("tjhrbputeamsiotu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Routing rules associated with this Front Door.
     */
    @JvmName("ftbjafgttkcwqxgj")
    public suspend fun routingRules(`value`: Output<List<RoutingRuleArgs>>) {
        this.routingRules = value
    }

    @JvmName("iyfpuwwesplxmglb")
    public suspend fun routingRules(vararg values: Output<RoutingRuleArgs>) {
        this.routingRules = Output.all(values.asList())
    }

    /**
     * @param values Routing rules associated with this Front Door.
     */
    @JvmName("lbpfmwisasbmpjrf")
    public suspend fun routingRules(values: List<Output<RoutingRuleArgs>>) {
        this.routingRules = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pfpqbheiqqxrkeeg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Backend pools available to routing rules.
     */
    @JvmName("pcwwmumbwpganjok")
    public suspend fun backendPools(`value`: List<BackendPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPools = mapped
    }

    /**
     * @param argument Backend pools available to routing rules.
     */
    @JvmName("kcigveoudegtcwvr")
    public suspend fun backendPools(argument: List<suspend BackendPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BackendPoolArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.backendPools = mapped
    }

    /**
     * @param argument Backend pools available to routing rules.
     */
    @JvmName("nblxujdwjuocppeu")
    public suspend fun backendPools(vararg argument: suspend BackendPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BackendPoolArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.backendPools = mapped
    }

    /**
     * @param argument Backend pools available to routing rules.
     */
    @JvmName("plipvlvabryemxpb")
    public suspend fun backendPools(argument: suspend BackendPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BackendPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backendPools = mapped
    }

    /**
     * @param values Backend pools available to routing rules.
     */
    @JvmName("ycvnuhcwkietowxh")
    public suspend fun backendPools(vararg values: BackendPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendPools = mapped
    }

    /**
     * @param value Settings for all backendPools
     */
    @JvmName("dglogeghwwwyuquc")
    public suspend fun backendPoolsSettings(`value`: BackendPoolsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPoolsSettings = mapped
    }

    /**
     * @param argument Settings for all backendPools
     */
    @JvmName("nytvtvbrvxmwiydo")
    public suspend fun backendPoolsSettings(argument: suspend BackendPoolsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BackendPoolsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendPoolsSettings = mapped
    }

    /**
     * @param value Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("mydgrsymqiakvhjn")
    public suspend fun enabledState(`value`: Either<String, FrontDoorEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("twkqohvfiwbkbpsc")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("xryluvgpjhynmkmo")
    public fun enabledState(`value`: FrontDoorEnabledState) {
        val toBeMapped = Either.ofRight<String, FrontDoorEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value A friendly name for the frontDoor
     */
    @JvmName("xmytkpmchrvyhqxp")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("tvrsicdawmudbljh")
    public suspend fun frontDoorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontDoorName = mapped
    }

    /**
     * @param value Frontend endpoints available to routing rules.
     */
    @JvmName("cijlbxjweegpmbpr")
    public suspend fun frontendEndpoints(`value`: List<FrontendEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints available to routing rules.
     */
    @JvmName("vogkocmrlrexhqqx")
    public suspend fun frontendEndpoints(argument: List<suspend FrontendEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints available to routing rules.
     */
    @JvmName("eingrxfkjfymemlx")
    public suspend fun frontendEndpoints(vararg argument: suspend FrontendEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FrontendEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints available to routing rules.
     */
    @JvmName("mleaysvtgekxmnkc")
    public suspend fun frontendEndpoints(argument: suspend FrontendEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FrontendEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param values Frontend endpoints available to routing rules.
     */
    @JvmName("tugmujatewjlngxl")
    public suspend fun frontendEndpoints(vararg values: FrontendEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendEndpoints = mapped
    }

    /**
     * @param value Health probe settings associated with this Front Door instance.
     */
    @JvmName("mmjwqtnfkrwjdppx")
    public suspend fun healthProbeSettings(`value`: List<HealthProbeSettingsModelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings associated with this Front Door instance.
     */
    @JvmName("gsxuiaxaboetcrfn")
    public suspend fun healthProbeSettings(argument: List<suspend HealthProbeSettingsModelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HealthProbeSettingsModelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings associated with this Front Door instance.
     */
    @JvmName("lijaqksrjogjrett")
    public suspend fun healthProbeSettings(vararg argument: suspend HealthProbeSettingsModelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HealthProbeSettingsModelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings associated with this Front Door instance.
     */
    @JvmName("yfsmrsdefatshdie")
    public suspend fun healthProbeSettings(argument: suspend HealthProbeSettingsModelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HealthProbeSettingsModelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param values Health probe settings associated with this Front Door instance.
     */
    @JvmName("ttueaihgmljlpdgj")
    public suspend fun healthProbeSettings(vararg values: HealthProbeSettingsModelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthProbeSettings = mapped
    }

    /**
     * @param value Load balancing settings associated with this Front Door instance.
     */
    @JvmName("fcilivoicruutifp")
    public suspend fun loadBalancingSettings(`value`: List<LoadBalancingSettingsModelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingSettings = mapped
    }

    /**
     * @param argument Load balancing settings associated with this Front Door instance.
     */
    @JvmName("gdtuotxiuauhgoyj")
    public suspend fun loadBalancingSettings(argument: List<suspend LoadBalancingSettingsModelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancingSettingsModelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingSettings = mapped
    }

    /**
     * @param argument Load balancing settings associated with this Front Door instance.
     */
    @JvmName("hnglswviwsgmkyaf")
    public suspend fun loadBalancingSettings(vararg argument: suspend LoadBalancingSettingsModelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoadBalancingSettingsModelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingSettings = mapped
    }

    /**
     * @param argument Load balancing settings associated with this Front Door instance.
     */
    @JvmName("jhjvmswaictuhinv")
    public suspend fun loadBalancingSettings(argument: suspend LoadBalancingSettingsModelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancingSettingsModelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancingSettings = mapped
    }

    /**
     * @param values Load balancing settings associated with this Front Door instance.
     */
    @JvmName("fvaqmrasmsgfutic")
    public suspend fun loadBalancingSettings(vararg values: LoadBalancingSettingsModelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancingSettings = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ctxjulgjcuhfyodx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("cmjtmjqdentjyrfd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Routing rules associated with this Front Door.
     */
    @JvmName("bixvuarnjtkcwmbb")
    public suspend fun routingRules(`value`: List<RoutingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules associated with this Front Door.
     */
    @JvmName("webnxgxpvsxiquwv")
    public suspend fun routingRules(argument: List<suspend RoutingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RoutingRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules associated with this Front Door.
     */
    @JvmName("jqvwchbreogsdldo")
    public suspend fun routingRules(vararg argument: suspend RoutingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RoutingRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules associated with this Front Door.
     */
    @JvmName("hgqevxeysswijbsu")
    public suspend fun routingRules(argument: suspend RoutingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RoutingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param values Routing rules associated with this Front Door.
     */
    @JvmName("rdjyxkrchaonbwgx")
    public suspend fun routingRules(vararg values: RoutingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dbhewfgutpecelbn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ygbqnotgahiqcbmn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FrontDoorArgs = FrontDoorArgs(
        backendPools = backendPools,
        backendPoolsSettings = backendPoolsSettings,
        enabledState = enabledState,
        friendlyName = friendlyName,
        frontDoorName = frontDoorName,
        frontendEndpoints = frontendEndpoints,
        healthProbeSettings = healthProbeSettings,
        loadBalancingSettings = loadBalancingSettings,
        location = location,
        resourceGroupName = resourceGroupName,
        routingRules = routingRules,
        tags = tags,
    )
}
