@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.InterfaceEndpointArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.EndpointServiceArgs
import com.pulumi.azurenative.network.kotlin.inputs.EndpointServiceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubnetArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubnetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Interface endpoint resource.
 * Azure REST API version: 2019-02-01.
 * ## Example Usage
 * ### Create interface endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var interfaceEndpoint = new AzureNative.Network.InterfaceEndpoint("interfaceEndpoint", new()
 *     {
 *         EndpointService = new AzureNative.Network.Inputs.EndpointServiceArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Provider/resourceType/resourceName",
 *         },
 *         Fqdn = "uniqueIdentifier.fqdn.windows.net",
 *         InterfaceEndpointName = "testIe",
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewInterfaceEndpoint(ctx, "interfaceEndpoint", &network.InterfaceEndpointArgs{
 * 			EndpointService: &network.EndpointServiceArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Provider/resourceType/resourceName"),
 * 			},
 * 			Fqdn:                  pulumi.String("uniqueIdentifier.fqdn.windows.net"),
 * 			InterfaceEndpointName: pulumi.String("testIe"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.InterfaceEndpoint;
 * import com.pulumi.azurenative.network.InterfaceEndpointArgs;
 * import com.pulumi.azurenative.network.inputs.EndpointServiceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var interfaceEndpoint = new InterfaceEndpoint("interfaceEndpoint", InterfaceEndpointArgs.builder()
 *             .endpointService(EndpointServiceArgs.builder()
 *                 .id("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Provider/resourceType/resourceName")
 *                 .build())
 *             .fqdn("uniqueIdentifier.fqdn.windows.net")
 *             .interfaceEndpointName("testIe")
 *             .resourceGroupName("rg1")
 *             .subnet(SubnetArgs.builder()
 *                 .id("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:InterfaceEndpoint testIe /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/interfaceEndpoints/{interfaceEndpointName}
 * ```
 * @property endpointService A reference to the service being brought into the virtual network.
 * @property fqdn A first-party service's FQDN that is mapped to the private IP allocated via this interface endpoint.
 * @property id Resource ID.
 * @property interfaceEndpointName The name of the interface endpoint.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property subnet The ID of the subnet from which the private IP will be allocated.
 * @property tags Resource tags.
 */
public data class InterfaceEndpointArgs(
    public val endpointService: Output<EndpointServiceArgs>? = null,
    public val fqdn: Output<String>? = null,
    public val id: Output<String>? = null,
    public val interfaceEndpointName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnet: Output<SubnetArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.InterfaceEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.InterfaceEndpointArgs =
        com.pulumi.azurenative.network.InterfaceEndpointArgs.builder()
            .endpointService(endpointService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .interfaceEndpointName(interfaceEndpointName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InterfaceEndpointArgs].
 */
@PulumiTagMarker
public class InterfaceEndpointArgsBuilder internal constructor() {
    private var endpointService: Output<EndpointServiceArgs>? = null

    private var fqdn: Output<String>? = null

    private var id: Output<String>? = null

    private var interfaceEndpointName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnet: Output<SubnetArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A reference to the service being brought into the virtual network.
     */
    @JvmName("lsuhkltxgglqtycb")
    public suspend fun endpointService(`value`: Output<EndpointServiceArgs>) {
        this.endpointService = value
    }

    /**
     * @param value A first-party service's FQDN that is mapped to the private IP allocated via this interface endpoint.
     */
    @JvmName("gwmwbhyqirbschjg")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wyxmnwdwwooxngnq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the interface endpoint.
     */
    @JvmName("qomqslycjpjodhqg")
    public suspend fun interfaceEndpointName(`value`: Output<String>) {
        this.interfaceEndpointName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("mgylqpodrookpugp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uwyjhcjkqncnlpiy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ID of the subnet from which the private IP will be allocated.
     */
    @JvmName("evygahkloblvtsvf")
    public suspend fun subnet(`value`: Output<SubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gjbnpjohumdacpxl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A reference to the service being brought into the virtual network.
     */
    @JvmName("jnxptftredtkwflr")
    public suspend fun endpointService(`value`: EndpointServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointService = mapped
    }

    /**
     * @param argument A reference to the service being brought into the virtual network.
     */
    @JvmName("eiokervkmfwqvucn")
    public suspend fun endpointService(argument: suspend EndpointServiceArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointService = mapped
    }

    /**
     * @param value A first-party service's FQDN that is mapped to the private IP allocated via this interface endpoint.
     */
    @JvmName("xkvvertctciqdfse")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("omrusjrmpisgsgfw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the interface endpoint.
     */
    @JvmName("oxirjdtmgegivivd")
    public suspend fun interfaceEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceEndpointName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ooasiapucabgvutl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bhcbbnnnewbcvwuq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ID of the subnet from which the private IP will be allocated.
     */
    @JvmName("erraypgbjddtyjsk")
    public suspend fun subnet(`value`: SubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The ID of the subnet from which the private IP will be allocated.
     */
    @JvmName("imwxbbgjbxxbmpsd")
    public suspend fun subnet(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hfyihvdebajytcxy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qwuenhmvmnhjdbkh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InterfaceEndpointArgs = InterfaceEndpointArgs(
        endpointService = endpointService,
        fqdn = fqdn,
        id = id,
        interfaceEndpointName = interfaceEndpointName,
        location = location,
        resourceGroupName = resourceGroupName,
        subnet = subnet,
        tags = tags,
    )
}
