@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IpGroup].
 */
@PulumiTagMarker
public class IpGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpGroupArgs = IpGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpGroupArgsBuilder.() -> Unit) {
        val builder = IpGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IpGroup {
        val builtJavaResource = com.pulumi.azurenative.network.IpGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IpGroup(builtJavaResource)
    }
}

/**
 * The IpGroups resource information.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### CreateOrUpdate_IpGroups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipGroup = new AzureNative.Network.IpGroup("ipGroup", new()
 *     {
 *         IpAddresses = new[]
 *         {
 *             "13.64.39.16/32",
 *             "40.74.146.80/31",
 *             "40.74.147.32/28",
 *         },
 *         IpGroupsName = "ipGroups1",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewIpGroup(ctx, "ipGroup", &network.IpGroupArgs{
 * 			IpAddresses: pulumi.StringArray{
 * 				pulumi.String("13.64.39.16/32"),
 * 				pulumi.String("40.74.146.80/31"),
 * 				pulumi.String("40.74.147.32/28"),
 * 			},
 * 			IpGroupsName:      pulumi.String("ipGroups1"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.IpGroup;
 * import com.pulumi.azurenative.network.IpGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipGroup = new IpGroup("ipGroup", IpGroupArgs.builder()
 *             .ipAddresses(
 *                 "13.64.39.16/32",
 *                 "40.74.146.80/31",
 *                 "40.74.147.32/28")
 *             .ipGroupsName("ipGroups1")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:IpGroup ipGroups1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}
 * ```
 */
public class IpGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.network.IpGroup,
) : KotlinCustomResource(javaResource, IpGroupMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * List of references to Firewall Policies resources that this IpGroups is associated with.
     */
    public val firewallPolicies: Output<List<SubResourceResponse>>
        get() = javaResource.firewallPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * List of references to Firewall resources that this IpGroups is associated with.
     */
    public val firewalls: Output<List<SubResourceResponse>>
        get() = javaResource.firewalls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * IpAddresses/IpAddressPrefixes in the IpGroups resource.
     */
    public val ipAddresses: Output<List<String>>?
        get() = javaResource.ipAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the IpGroups resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IpGroupMapper : ResourceMapper<IpGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.IpGroup::class == javaResource::class

    override fun map(javaResource: Resource): IpGroup = IpGroup(
        javaResource as
            com.pulumi.azurenative.network.IpGroup,
    )
}

/**
 * @see [IpGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpGroup].
 */
public suspend fun ipGroup(name: String, block: suspend IpGroupResourceBuilder.() -> Unit): IpGroup {
    val builder = IpGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipGroup(name: String): IpGroup {
    val builder = IpGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
