@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.IpGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The IpGroups resource information.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### CreateOrUpdate_IpGroups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipGroup = new AzureNative.Network.IpGroup("ipGroup", new()
 *     {
 *         IpAddresses = new[]
 *         {
 *             "13.64.39.16/32",
 *             "40.74.146.80/31",
 *             "40.74.147.32/28",
 *         },
 *         IpGroupsName = "ipGroups1",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewIpGroup(ctx, "ipGroup", &network.IpGroupArgs{
 * 			IpAddresses: pulumi.StringArray{
 * 				pulumi.String("13.64.39.16/32"),
 * 				pulumi.String("40.74.146.80/31"),
 * 				pulumi.String("40.74.147.32/28"),
 * 			},
 * 			IpGroupsName:      pulumi.String("ipGroups1"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.IpGroup;
 * import com.pulumi.azurenative.network.IpGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipGroup = new IpGroup("ipGroup", IpGroupArgs.builder()
 *             .ipAddresses(
 *                 "13.64.39.16/32",
 *                 "40.74.146.80/31",
 *                 "40.74.147.32/28")
 *             .ipGroupsName("ipGroups1")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:IpGroup ipGroups1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ipGroups/{ipGroupsName}
 * ```
 * @property id Resource ID.
 * @property ipAddresses IpAddresses/IpAddressPrefixes in the IpGroups resource.
 * @property ipGroupsName The name of the ipGroups.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class IpGroupArgs(
    public val id: Output<String>? = null,
    public val ipAddresses: Output<List<String>>? = null,
    public val ipGroupsName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.IpGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.IpGroupArgs =
        com.pulumi.azurenative.network.IpGroupArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipGroupsName(ipGroupsName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IpGroupArgs].
 */
@PulumiTagMarker
public class IpGroupArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var ipAddresses: Output<List<String>>? = null

    private var ipGroupsName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("pngeoxnjgrumlhbm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IpAddresses/IpAddressPrefixes in the IpGroups resource.
     */
    @JvmName("sprkhdnghiykjaou")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("lydnflbmrohmrjrv")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values IpAddresses/IpAddressPrefixes in the IpGroups resource.
     */
    @JvmName("yyowqddgcvntxoop")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value The name of the ipGroups.
     */
    @JvmName("gdvciaijccqppbgr")
    public suspend fun ipGroupsName(`value`: Output<String>) {
        this.ipGroupsName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("bkldcswcyddbqwfv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ufluywmsgkjpkytu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sbdtoakthbvubajk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tfamemomjbsqpdef")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value IpAddresses/IpAddressPrefixes in the IpGroups resource.
     */
    @JvmName("brdhieivgyixssfl")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values IpAddresses/IpAddressPrefixes in the IpGroups resource.
     */
    @JvmName("ypyryghqhwcqawkf")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value The name of the ipGroups.
     */
    @JvmName("hkanlvebhqibarrf")
    public suspend fun ipGroupsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipGroupsName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xhxqfyoupoiogyap")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("phekylgajmceklnw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jefsargpxjhafxob")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("doqwpaugvxpyfbss")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IpGroupArgs = IpGroupArgs(
        id = id,
        ipAddresses = ipAddresses,
        ipGroupsName = ipGroupsName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
