@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.LoadBalancerArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.BackendAddressPoolArgs
import com.pulumi.azurenative.network.kotlin.inputs.BackendAddressPoolArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FrontendIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.FrontendIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.InboundNatPoolArgs
import com.pulumi.azurenative.network.kotlin.inputs.InboundNatPoolArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.InboundNatRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.InboundNatRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancerSkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancerSkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancingRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancingRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.OutboundRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.OutboundRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ProbeArgs
import com.pulumi.azurenative.network.kotlin.inputs.ProbeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * LoadBalancer resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2018-06-01, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create load balancer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(false),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(false),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .enableTcpReset(false)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(true)
 *                 .enableTcpReset(false)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Frontend IP in Zone 1
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *                 Zones = new[]
 *                 {
 *                     "1",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 					Zones: pulumi.StringArray{
 * 						pulumi.String("1"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .zones("1")
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Consumer configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 GatewayLoadBalancer = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider",
 *                 },
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					GatewayLoadBalancer: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider"),
 * 					},
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .gatewayLoadBalancer(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider")
 *                     .build())
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Provider configured with one Backend Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *                 TunnelInterfaces = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.GatewayLoadBalancerTunnelInterfaceArgs
 *                     {
 *                         Identifier = 900,
 *                         Port = 15000,
 *                         Protocol = AzureNative.Network.GatewayLoadBalancerTunnelProtocol.VXLAN,
 *                         Type = AzureNative.Network.GatewayLoadBalancerTunnelInterfaceType.Internal,
 *                     },
 *                     new AzureNative.Network.Inputs.GatewayLoadBalancerTunnelInterfaceArgs
 *                     {
 *                         Identifier = 901,
 *                         Port = 15001,
 *                         Protocol = AzureNative.Network.GatewayLoadBalancerTunnelProtocol.VXLAN,
 *                         Type = AzureNative.Network.GatewayLoadBalancerTunnelInterfaceType.Internal,
 *                     },
 *                 },
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPools = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                     },
 *                 },
 *                 BackendPort = 0,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 0,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.All,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 					TunnelInterfaces: network.GatewayLoadBalancerTunnelInterfaceArray{
 * 						&network.GatewayLoadBalancerTunnelInterfaceArgs{
 * 							Identifier: pulumi.Int(900),
 * 							Port:       pulumi.Int(15000),
 * 							Protocol:   pulumi.String(network.GatewayLoadBalancerTunnelProtocolVXLAN),
 * 							Type:       pulumi.String(network.GatewayLoadBalancerTunnelInterfaceTypeInternal),
 * 						},
 * 						&network.GatewayLoadBalancerTunnelInterfaceArgs{
 * 							Identifier: pulumi.Int(901),
 * 							Port:       pulumi.Int(15001),
 * 							Protocol:   pulumi.String(network.GatewayLoadBalancerTunnelProtocolVXLAN),
 * 							Type:       pulumi.String(network.GatewayLoadBalancerTunnelInterfaceTypeInternal),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools:  network.InboundNatPoolArray{},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPools: network.SubResourceArray{
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 						},
 * 					},
 * 					BackendPort:      pulumi.Int(0),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(0),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolAll),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .tunnelInterfaces(
 *                     GatewayLoadBalancerTunnelInterfaceArgs.builder()
 *                         .identifier(900)
 *                         .port(15000)
 *                         .protocol("VXLAN")
 *                         .type("Internal")
 *                         .build(),
 *                     GatewayLoadBalancerTunnelInterfaceArgs.builder()
 *                         .identifier(901)
 *                         .port(15001)
 *                         .protocol("VXLAN")
 *                         .type("Internal")
 *                         .build())
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPools(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(0)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(0)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("All")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Premium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Provider configured with two Backend Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb1",
 *             },
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb2",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = null,
 *                 BackendAddressPools = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2",
 *                     },
 *                 },
 *                 BackendPort = 0,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 0,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.All,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb1"),
 * 				},
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb2"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools:  network.InboundNatPoolArray{},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: nil,
 * 					BackendAddressPools: network.SubResourceArray{
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1"),
 * 						},
 * 						&network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2"),
 * 						},
 * 					},
 * 					BackendPort:      pulumi.Int(0),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(0),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolAll),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(
 *                 BackendAddressPoolArgs.builder()
 *                     .name("be-lb1")
 *                     .build(),
 *                 BackendAddressPoolArgs.builder()
 *                     .name("be-lb2")
 *                     .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool()
 *                 .backendAddressPools(
 *                     SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1")
 *                         .build(),
 *                     SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2")
 *                         .build())
 *                 .backendPort(0)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(0)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("All")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Premium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Global Tier and one regional load balancer in its backend pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 LoadBalancerBackendAddresses = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.LoadBalancerBackendAddressArgs
 *                     {
 *                         LoadBalancerFrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb",
 *                         },
 *                         Name = "regional-lb1-address",
 *                     },
 *                 },
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *             Tier = AzureNative.Network.LoadBalancerSkuTier.Global,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					LoadBalancerBackendAddresses: network.LoadBalancerBackendAddressArray{
 * 						&network.LoadBalancerBackendAddressArgs{
 * 							LoadBalancerFrontendIPConfiguration: &network.SubResourceArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb"),
 * 							},
 * 							Name: pulumi.String("regional-lb1-address"),
 * 						},
 * 					},
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(false),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 				Tier: pulumi.String(network.LoadBalancerSkuTierGlobal),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .loadBalancerBackendAddresses(LoadBalancerBackendAddressArgs.builder()
 *                     .loadBalancerFrontendIPConfiguration(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb")
 *                         .build())
 *                     .name("regional-lb1-address")
 *                     .build())
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(false)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .tier("Global")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Standard SKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{
 * 				&network.BackendAddressPoolArgs{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: network.InboundNatRuleTypeArray{
 * 				&network.InboundNatRuleTypeArgs{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{
 * 				&network.LoadBalancingRuleArgs{
 * 					BackendAddressPool: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String(network.LoadDistributionDefault),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: network.ProbeArray{
 * 				&network.ProbeArgs{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String(network.ProbeProtocolHttp),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with inbound nat pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[] {},
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test",
 *                 Name = "test",
 *                 PrivateIPAllocationMethod = AzureNative.Network.IPAllocationMethod.Dynamic,
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet",
 *                 },
 *                 Zones = new() { },
 *             },
 *         },
 *         InboundNatPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatPoolArgs
 *             {
 *                 BackendPort = 8888,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test",
 *                 },
 *                 FrontendPortRangeEnd = 8085,
 *                 FrontendPortRangeStart = 8080,
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test",
 *                 IdleTimeoutInMinutes = 10,
 *                 Name = "test",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         InboundNatRules = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[] {},
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[] {},
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{},
 * 			FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Id:                        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test"),
 * 					Name:                      pulumi.String("test"),
 * 					PrivateIPAllocationMethod: pulumi.String(network.IPAllocationMethodDynamic),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet"),
 * 					},
 * 					Zones: pulumi.StringArray{},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{
 * 				&network.InboundNatPoolArgs{
 * 					BackendPort:      pulumi.Int(8888),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(true),
 * 					FrontendIPConfiguration: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test"),
 * 					},
 * 					FrontendPortRangeEnd:   pulumi.Int(8085),
 * 					FrontendPortRangeStart: pulumi.Int(8080),
 * 					Id:                     pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test"),
 * 					IdleTimeoutInMinutes:   pulumi.Int(10),
 * 					Name:                   pulumi.String("test"),
 * 					Protocol:               pulumi.String(network.TransportProtocolTcp),
 * 				},
 * 			},
 * 			InboundNatRules:    network.InboundNatRuleTypeArray{},
 * 			LoadBalancerName:   pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{},
 * 			Location:           pulumi.String("eastus"),
 * 			OutboundRules:      network.OutboundRuleArray{},
 * 			Probes:             network.ProbeArray{},
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatPoolArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools()
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test")
 *                 .name("test")
 *                 .privateIPAllocationMethod("Dynamic")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet")
 *                     .build())
 *                 .zones()
 *                 .build())
 *             .inboundNatPools(InboundNatPoolArgs.builder()
 *                 .backendPort(8888)
 *                 .enableFloatingIP(true)
 *                 .enableTcpReset(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test")
 *                     .build())
 *                 .frontendPortRangeEnd(8085)
 *                 .frontendPortRangeStart(8080)
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test")
 *                 .idleTimeoutInMinutes(10)
 *                 .name("test")
 *                 .protocol("Tcp")
 *                 .build())
 *             .inboundNatRules()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules()
 *             .location("eastus")
 *             .outboundRules()
 *             .probes()
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with outbound rules
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.PublicIPAddressArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 DisableOutboundSnat = true,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = AzureNative.Network.LoadDistribution.Default,
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = AzureNative.Network.TransportProtocol.Tcp,
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.OutboundRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 FrontendIPConfigurations = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                     },
 *                 },
 *                 Name = "rule1",
 *                 Protocol = AzureNative.Network.LoadBalancerOutboundRuleProtocol.All,
 *             },
 *         },
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = AzureNative.Network.ProbeProtocol.Http,
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = AzureNative.Network.LoadBalancerSkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * BackendAddressPools: network.BackendAddressPoolArray{
 * &network.BackendAddressPoolArgs{
 * Name: pulumi.String("be-lb"),
 * },
 * },
 * FrontendIPConfigurations: network.FrontendIPConfigurationArray{
 * interface{}{
 * Name: pulumi.String("fe-lb"),
 * PublicIPAddress: &network.PublicIPAddressTypeArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip"),
 * },
 * },
 * },
 * InboundNatPools: network.InboundNatPoolArray{
 * },
 * InboundNatRules: network.InboundNatRuleTypeArray{
 * &network.InboundNatRuleTypeArgs{
 * BackendPort: pulumi.Int(3389),
 * EnableFloatingIP: pulumi.Bool(true),
 * FrontendIPConfiguration: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * },
 * FrontendPort: pulumi.Int(3389),
 * IdleTimeoutInMinutes: pulumi.Int(15),
 * Name: pulumi.String("in-nat-rule"),
 * Protocol: pulumi.String(network.TransportProtocolTcp),
 * },
 * },
 * LoadBalancerName: pulumi.String("lb"),
 * LoadBalancingRules: network.LoadBalancingRuleArray{
 * &network.LoadBalancingRuleArgs{
 * BackendAddressPool: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * },
 * BackendPort: pulumi.Int(80),
 * DisableOutboundSnat: pulumi.Bool(true),
 * EnableFloatingIP: pulumi.Bool(true),
 * FrontendIPConfiguration: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * },
 * FrontendPort: pulumi.Int(80),
 * IdleTimeoutInMinutes: pulumi.Int(15),
 * LoadDistribution: pulumi.String(network.LoadDistributionDefault),
 * Name: pulumi.String("rulelb"),
 * Probe: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * },
 * Protocol: pulumi.String(network.TransportProtocolTcp),
 * },
 * },
 * Location: pulumi.String("eastus"),
 * OutboundRules: network.OutboundRuleArray{
 * &network.OutboundRuleArgs{
 * BackendAddressPool: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * },
 * FrontendIPConfigurations: network.SubResourceArray{
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * },
 * },
 * Name: pulumi.String("rule1"),
 * Protocol: pulumi.String(network.LoadBalancerOutboundRuleProtocolAll),
 * },
 * },
 * Probes: network.ProbeArray{
 * &network.ProbeArgs{
 * IntervalInSeconds: pulumi.Int(15),
 * Name: pulumi.String("probe-lb"),
 * NumberOfProbes: pulumi.Int(2),
 * Port: pulumi.Int(80),
 * ProbeThreshold: pulumi.Int(1),
 * Protocol: pulumi.String(network.ProbeProtocolHttp),
 * RequestPath: pulumi.String("healthcheck.aspx"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Sku: &network.LoadBalancerSkuArgs{
 * Name: pulumi.String(network.LoadBalancerSkuNameStandard),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import com.pulumi.azurenative.network.inputs.BackendAddressPoolArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPAddressArgs;
 * import com.pulumi.azurenative.network.inputs.InboundNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancingRuleArgs;
 * import com.pulumi.azurenative.network.inputs.OutboundRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ProbeArgs;
 * import com.pulumi.azurenative.network.inputs.LoadBalancerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(BackendAddressPoolArgs.builder()
 *                 .name("be-lb")
 *                 .build())
 *             .frontendIPConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .publicIPAddress(PublicIPAddressArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip")
 *                     .build())
 *                 .build())
 *             .inboundNatPools()
 *             .inboundNatRules(InboundNatRuleArgs.builder()
 *                 .backendPort(3389)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(3389)
 *                 .idleTimeoutInMinutes(15)
 *                 .name("in-nat-rule")
 *                 .protocol("Tcp")
 *                 .build())
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(LoadBalancingRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .backendPort(80)
 *                 .disableOutboundSnat(true)
 *                 .enableFloatingIP(true)
 *                 .frontendIPConfiguration(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .frontendPort(80)
 *                 .idleTimeoutInMinutes(15)
 *                 .loadDistribution("Default")
 *                 .name("rulelb")
 *                 .probe(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")
 *                     .build())
 *                 .protocol("Tcp")
 *                 .build())
 *             .location("eastus")
 *             .outboundRules(OutboundRuleArgs.builder()
 *                 .backendAddressPool(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")
 *                     .build())
 *                 .frontendIPConfigurations(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                     .build())
 *                 .name("rule1")
 *                 .protocol("All")
 *                 .build())
 *             .probes(ProbeArgs.builder()
 *                 .intervalInSeconds(15)
 *                 .name("probe-lb")
 *                 .numberOfProbes(2)
 *                 .port(80)
 *                 .probeThreshold(1)
 *                 .protocol("Http")
 *                 .requestPath("healthcheck.aspx")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(LoadBalancerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:LoadBalancer lb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}
 * ```
 * @property backendAddressPools Collection of backend address pools used by a load balancer.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property extendedLocation The extended location of the load balancer.
 * @property frontendIPConfigurations Object representing the frontend IPs to be used for the load balancer.
 * @property id Resource ID.
 * @property inboundNatPools Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
 * @property inboundNatRules Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property loadBalancerName The name of the load balancer.
 * @property loadBalancingRules Object collection representing the load balancing rules Gets the provisioning.
 * @property location Resource location.
 * @property outboundRules The outbound rules.
 * @property probes Collection of probe objects used in the load balancer.
 * @property resourceGroupName The name of the resource group.
 * @property sku The load balancer SKU.
 * @property tags Resource tags.
 */
public data class LoadBalancerArgs(
    public val backendAddressPools: Output<List<BackendAddressPoolArgs>>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val frontendIPConfigurations: Output<List<FrontendIPConfigurationArgs>>? = null,
    public val id: Output<String>? = null,
    public val inboundNatPools: Output<List<InboundNatPoolArgs>>? = null,
    public val inboundNatRules: Output<List<InboundNatRuleArgs>>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val loadBalancingRules: Output<List<LoadBalancingRuleArgs>>? = null,
    public val location: Output<String>? = null,
    public val outboundRules: Output<List<OutboundRuleArgs>>? = null,
    public val probes: Output<List<ProbeArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<LoadBalancerSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.azurenative.network.LoadBalancerArgs =
        com.pulumi.azurenative.network.LoadBalancerArgs.builder()
            .backendAddressPools(
                backendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .frontendIPConfigurations(
                frontendIPConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .inboundNatPools(
                inboundNatPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inboundNatRules(
                inboundNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .loadBalancingRules(
                loadBalancingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .outboundRules(
                outboundRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .probes(probes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var backendAddressPools: Output<List<BackendAddressPoolArgs>>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var frontendIPConfigurations: Output<List<FrontendIPConfigurationArgs>>? = null

    private var id: Output<String>? = null

    private var inboundNatPools: Output<List<InboundNatPoolArgs>>? = null

    private var inboundNatRules: Output<List<InboundNatRuleArgs>>? = null

    private var loadBalancerName: Output<String>? = null

    private var loadBalancingRules: Output<List<LoadBalancingRuleArgs>>? = null

    private var location: Output<String>? = null

    private var outboundRules: Output<List<OutboundRuleArgs>>? = null

    private var probes: Output<List<ProbeArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<LoadBalancerSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ysktpejlxhcofdhc")
    public suspend fun backendAddressPools(`value`: Output<List<BackendAddressPoolArgs>>) {
        this.backendAddressPools = value
    }

    @JvmName("gslpepvaucbhxojb")
    public suspend fun backendAddressPools(vararg values: Output<BackendAddressPoolArgs>) {
        this.backendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("dtrerrysdwtvxtnv")
    public suspend fun backendAddressPools(values: List<Output<BackendAddressPoolArgs>>) {
        this.backendAddressPools = Output.all(values)
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("tqywrerkvthxhhej")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("ldulrfqpfyfdlabs")
    public suspend fun frontendIPConfigurations(`value`: Output<List<FrontendIPConfigurationArgs>>) {
        this.frontendIPConfigurations = value
    }

    @JvmName("fkxcnhulgpbqftxa")
    public suspend fun frontendIPConfigurations(vararg values: Output<FrontendIPConfigurationArgs>) {
        this.frontendIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("atibyixmqknymuhd")
    public suspend fun frontendIPConfigurations(values: List<Output<FrontendIPConfigurationArgs>>) {
        this.frontendIPConfigurations = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xqeiatqjyqmchjxc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("xexcjhocptntihhf")
    public suspend fun inboundNatPools(`value`: Output<List<InboundNatPoolArgs>>) {
        this.inboundNatPools = value
    }

    @JvmName("qscwtbajhpmtrflx")
    public suspend fun inboundNatPools(vararg values: Output<InboundNatPoolArgs>) {
        this.inboundNatPools = Output.all(values.asList())
    }

    /**
     * @param values Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("akuepnjwvsmytgwm")
    public suspend fun inboundNatPools(values: List<Output<InboundNatPoolArgs>>) {
        this.inboundNatPools = Output.all(values)
    }

    /**
     * @param value Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xwhjsrrffwqevlgq")
    public suspend fun inboundNatRules(`value`: Output<List<InboundNatRuleArgs>>) {
        this.inboundNatRules = value
    }

    @JvmName("qmggysfpbodelaqb")
    public suspend fun inboundNatRules(vararg values: Output<InboundNatRuleArgs>) {
        this.inboundNatRules = Output.all(values.asList())
    }

    /**
     * @param values Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("mcgqaobljvaqilha")
    public suspend fun inboundNatRules(values: List<Output<InboundNatRuleArgs>>) {
        this.inboundNatRules = Output.all(values)
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("imnpkqekwxodvniy")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("qotavfketrxakgyb")
    public suspend fun loadBalancingRules(`value`: Output<List<LoadBalancingRuleArgs>>) {
        this.loadBalancingRules = value
    }

    @JvmName("mayntcsxgtwnwqvx")
    public suspend fun loadBalancingRules(vararg values: Output<LoadBalancingRuleArgs>) {
        this.loadBalancingRules = Output.all(values.asList())
    }

    /**
     * @param values Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("umvoiuokkbeoennp")
    public suspend fun loadBalancingRules(values: List<Output<LoadBalancingRuleArgs>>) {
        this.loadBalancingRules = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("irjrammoqeflstys")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The outbound rules.
     */
    @JvmName("lwtkvuxqswkqetwt")
    public suspend fun outboundRules(`value`: Output<List<OutboundRuleArgs>>) {
        this.outboundRules = value
    }

    @JvmName("dldtdxcjwrvauave")
    public suspend fun outboundRules(vararg values: Output<OutboundRuleArgs>) {
        this.outboundRules = Output.all(values.asList())
    }

    /**
     * @param values The outbound rules.
     */
    @JvmName("mfbroxlulojyugyd")
    public suspend fun outboundRules(values: List<Output<OutboundRuleArgs>>) {
        this.outboundRules = Output.all(values)
    }

    /**
     * @param value Collection of probe objects used in the load balancer.
     */
    @JvmName("ncyvptpthlqlvyas")
    public suspend fun probes(`value`: Output<List<ProbeArgs>>) {
        this.probes = value
    }

    @JvmName("gsqhptdtsobxsjrf")
    public suspend fun probes(vararg values: Output<ProbeArgs>) {
        this.probes = Output.all(values.asList())
    }

    /**
     * @param values Collection of probe objects used in the load balancer.
     */
    @JvmName("luetmvppidejerfo")
    public suspend fun probes(values: List<Output<ProbeArgs>>) {
        this.probes = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uurslputbgvjibno")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The load balancer SKU.
     */
    @JvmName("lcvpyrdwtstnrvgp")
    public suspend fun sku(`value`: Output<LoadBalancerSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("junootnsoswmqggu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jlvvmsrbngejhfkf")
    public suspend fun backendAddressPools(`value`: List<BackendAddressPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("cfwlbnwrtlpgdckd")
    public suspend fun backendAddressPools(argument: List<suspend BackendAddressPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BackendAddressPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hrclflwnjmnjmdjm")
    public suspend fun backendAddressPools(vararg argument: suspend BackendAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BackendAddressPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("wlhlcmrelymrmnoj")
    public suspend fun backendAddressPools(argument: suspend BackendAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BackendAddressPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param values Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("vftrcbfosdfrlaia")
    public suspend fun backendAddressPools(vararg values: BackendAddressPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("mcdjnpxmnxpksmxq")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the load balancer.
     */
    @JvmName("ycqlxjlilnmfjlfb")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("abhdhqlrcusaxpxs")
    public suspend fun frontendIPConfigurations(`value`: List<FrontendIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("mhjfldcdninssryk")
    public suspend fun frontendIPConfigurations(argument: List<suspend FrontendIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("pummgyrygjmtlbui")
    public suspend fun frontendIPConfigurations(vararg argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("jphxoyurfoqwbugt")
    public suspend fun frontendIPConfigurations(argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontendIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param values Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("ybqfqreihvbxqtxb")
    public suspend fun frontendIPConfigurations(vararg values: FrontendIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yhycyjjmetptwyml")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("bqkguqdajlhdjgmi")
    public suspend fun inboundNatPools(`value`: List<InboundNatPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundNatPools = mapped
    }

    /**
     * @param argument Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("pwenbruppyimmncb")
    public suspend fun inboundNatPools(argument: List<suspend InboundNatPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundNatPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param argument Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("oknmcwrexjwfgtqf")
    public suspend fun inboundNatPools(vararg argument: suspend InboundNatPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InboundNatPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param argument Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("yxobvoudyxebokuc")
    public suspend fun inboundNatPools(argument: suspend InboundNatPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundNatPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param values Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("nahojpbhmvrqwdsf")
    public suspend fun inboundNatPools(vararg values: InboundNatPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundNatPools = mapped
    }

    /**
     * @param value Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("uqvdqswfiokgtyqd")
    public suspend fun inboundNatRules(`value`: List<InboundNatRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundNatRules = mapped
    }

    /**
     * @param argument Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("movqnlgcsamaurum")
    public suspend fun inboundNatRules(argument: List<suspend InboundNatRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param argument Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("rxupndwvykdnonxh")
    public suspend fun inboundNatRules(vararg argument: suspend InboundNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InboundNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param argument Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("psfnistsjcehnyfd")
    public suspend fun inboundNatRules(argument: suspend InboundNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundNatRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param values Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("qacekyrgimfbneys")
    public suspend fun inboundNatRules(vararg values: InboundNatRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundNatRules = mapped
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("cvgaqrksgxatjwjq")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("fpxmmbvabeiaqnuu")
    public suspend fun loadBalancingRules(`value`: List<LoadBalancingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("kpvarkwkowiimkhu")
    public suspend fun loadBalancingRules(argument: List<suspend LoadBalancingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("nkcdxqwpxknkatyt")
    public suspend fun loadBalancingRules(vararg argument: suspend LoadBalancingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoadBalancingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("qucoxbiyibchagku")
    public suspend fun loadBalancingRules(argument: suspend LoadBalancingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LoadBalancingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param values Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("iigrswbdynvrqgfr")
    public suspend fun loadBalancingRules(vararg values: LoadBalancingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancingRules = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("skwljcihhmwduoxl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The outbound rules.
     */
    @JvmName("hoihjceidwiniexk")
    public suspend fun outboundRules(`value`: List<OutboundRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundRules = mapped
    }

    /**
     * @param argument The outbound rules.
     */
    @JvmName("yndftubkxccnafha")
    public suspend fun outboundRules(argument: List<suspend OutboundRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OutboundRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outboundRules = mapped
    }

    /**
     * @param argument The outbound rules.
     */
    @JvmName("xygmnxdbtemofhmk")
    public suspend fun outboundRules(vararg argument: suspend OutboundRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OutboundRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outboundRules = mapped
    }

    /**
     * @param argument The outbound rules.
     */
    @JvmName("ivmrukuwaeqsohhq")
    public suspend fun outboundRules(argument: suspend OutboundRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OutboundRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.outboundRules = mapped
    }

    /**
     * @param values The outbound rules.
     */
    @JvmName("wflwkbwcsmyiorbb")
    public suspend fun outboundRules(vararg values: OutboundRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outboundRules = mapped
    }

    /**
     * @param value Collection of probe objects used in the load balancer.
     */
    @JvmName("bnmoqsnkesigkvpx")
    public suspend fun probes(`value`: List<ProbeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probes = mapped
    }

    /**
     * @param argument Collection of probe objects used in the load balancer.
     */
    @JvmName("qxrgvbgnswsuybja")
    public suspend fun probes(argument: List<suspend ProbeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ProbeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param argument Collection of probe objects used in the load balancer.
     */
    @JvmName("nefwdcmdmydsmfkm")
    public suspend fun probes(vararg argument: suspend ProbeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ProbeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param argument Collection of probe objects used in the load balancer.
     */
    @JvmName("guvmnnaqmtetepgf")
    public suspend fun probes(argument: suspend ProbeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProbeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param values Collection of probe objects used in the load balancer.
     */
    @JvmName("vvnqeqqoytxkyliu")
    public suspend fun probes(vararg values: ProbeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.probes = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("felciauntlmodjrs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The load balancer SKU.
     */
    @JvmName("pkaclblciqlxdmun")
    public suspend fun sku(`value`: LoadBalancerSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The load balancer SKU.
     */
    @JvmName("kpaeybuybohkwiwu")
    public suspend fun sku(argument: suspend LoadBalancerSkuArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tjbkxujjieuxrrev")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hmlmdmvipyittdkh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        backendAddressPools = backendAddressPools,
        extendedLocation = extendedLocation,
        frontendIPConfigurations = frontendIPConfigurations,
        id = id,
        inboundNatPools = inboundNatPools,
        inboundNatRules = inboundNatRules,
        loadBalancerName = loadBalancerName,
        loadBalancingRules = loadBalancingRules,
        location = location,
        outboundRules = outboundRules,
        probes = probes,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
