@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.NatGatewaySkuResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.NatGatewaySkuResponse.Companion.toKotlin as natGatewaySkuResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [NatGateway].
 */
@PulumiTagMarker
public class NatGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NatGatewayArgs = NatGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NatGatewayArgsBuilder.() -> Unit) {
        val builder = NatGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NatGateway {
        val builtJavaResource = com.pulumi.azurenative.network.NatGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NatGateway(builtJavaResource)
    }
}

/**
 * Nat Gateway resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create nat gateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var natGateway = new AzureNative.Network.NatGateway("natGateway", new()
 *     {
 *         Location = "westus",
 *         NatGatewayName = "test-natgateway",
 *         PublicIpAddresses = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/PublicIpAddress1",
 *             },
 *         },
 *         PublicIpPrefixes = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPPrefixes/PublicIpPrefix1",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.NatGatewaySkuArgs
 *         {
 *             Name = AzureNative.Network.NatGatewaySkuName.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNatGateway(ctx, "natGateway", &network.NatGatewayArgs{
 * 			Location:       pulumi.String("westus"),
 * 			NatGatewayName: pulumi.String("test-natgateway"),
 * 			PublicIpAddresses: network.SubResourceArray{
 * 				&network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/PublicIpAddress1"),
 * 				},
 * 			},
 * 			PublicIpPrefixes: network.SubResourceArray{
 * 				&network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPPrefixes/PublicIpPrefix1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.NatGatewaySkuArgs{
 * 				Name: pulumi.String(network.NatGatewaySkuNameStandard),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NatGateway;
 * import com.pulumi.azurenative.network.NatGatewayArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.NatGatewaySkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var natGateway = new NatGateway("natGateway", NatGatewayArgs.builder()
 *             .location("westus")
 *             .natGatewayName("test-natgateway")
 *             .publicIpAddresses(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/PublicIpAddress1")
 *                 .build())
 *             .publicIpPrefixes(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPPrefixes/PublicIpPrefix1")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sku(NatGatewaySkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NatGateway test-natGateway /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}
 * ```
 */
public class NatGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NatGateway,
) : KotlinCustomResource(javaResource, NatGatewayMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The idle timeout of the nat gateway.
     */
    public val idleTimeoutInMinutes: Output<Int>?
        get() = javaResource.idleTimeoutInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the NAT gateway resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * An array of public ip addresses associated with the nat gateway resource.
     */
    public val publicIpAddresses: Output<List<SubResourceResponse>>?
        get() = javaResource.publicIpAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        subResourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of public ip prefixes associated with the nat gateway resource.
     */
    public val publicIpPrefixes: Output<List<SubResourceResponse>>?
        get() = javaResource.publicIpPrefixes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        subResourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The resource GUID property of the NAT gateway resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The nat gateway SKU.
     */
    public val sku: Output<NatGatewaySkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    natGatewaySkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * An array of references to the subnets using this nat gateway resource.
     */
    public val subnets: Output<List<SubResourceResponse>>
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object NatGatewayMapper : ResourceMapper<NatGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NatGateway::class == javaResource::class

    override fun map(javaResource: Resource): NatGateway = NatGateway(
        javaResource as
            com.pulumi.azurenative.network.NatGateway,
    )
}

/**
 * @see [NatGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NatGateway].
 */
public suspend fun natGateway(name: String, block: suspend NatGatewayResourceBuilder.() -> Unit): NatGateway {
    val builder = NatGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NatGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun natGateway(name: String): NatGateway {
    val builder = NatGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
