@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkExperimentProfileArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.State
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines an Network Experiment Profile and lists of Experiments
 * Azure REST API version: 2019-11-01. Prior API version in Azure Native 1.x: 2019-11-01.
 * ## Example Usage
 * ### Creates an NetworkExperiment Profile in a Resource Group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkExperimentProfile = new AzureNative.Network.NetworkExperimentProfile("networkExperimentProfile", new()
 *     {
 *         EnabledState = AzureNative.Network.State.Enabled,
 *         Location = "WestUs",
 *         ProfileName = "MyProfile",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkExperimentProfile(ctx, "networkExperimentProfile", &network.NetworkExperimentProfileArgs{
 * 			EnabledState:      pulumi.String(network.StateEnabled),
 * 			Location:          pulumi.String("WestUs"),
 * 			ProfileName:       pulumi.String("MyProfile"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkExperimentProfile;
 * import com.pulumi.azurenative.network.NetworkExperimentProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkExperimentProfile = new NetworkExperimentProfile("networkExperimentProfile", NetworkExperimentProfileArgs.builder()
 *             .enabledState("Enabled")
 *             .location("WestUs")
 *             .profileName("MyProfile")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkExperimentProfile MyProfile /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}
 * ```
 * @property enabledState The state of the Experiment
 * @property location Resource location.
 * @property name The name of the Profile
 * @property profileName The Profile identifier associated with the Tenant and Partner
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property tags Resource tags.
 */
public data class NetworkExperimentProfileArgs(
    public val enabledState: Output<Either<String, State>>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkExperimentProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkExperimentProfileArgs =
        com.pulumi.azurenative.network.NetworkExperimentProfileArgs.builder()
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkExperimentProfileArgs].
 */
@PulumiTagMarker
public class NetworkExperimentProfileArgsBuilder internal constructor() {
    private var enabledState: Output<Either<String, State>>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The state of the Experiment
     */
    @JvmName("dfvjjbdfmbsrptil")
    public suspend fun enabledState(`value`: Output<Either<String, State>>) {
        this.enabledState = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tmcrcjafwdchlfsm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Profile
     */
    @JvmName("oawabvnihgkwdkpl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Profile identifier associated with the Tenant and Partner
     */
    @JvmName("aajkgjpsvulmierh")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("cadqpdnylwfwfbfk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qbhwkqadkyjhbmne")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The state of the Experiment
     */
    @JvmName("awxwaqvwlutibaeg")
    public suspend fun enabledState(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value The state of the Experiment
     */
    @JvmName("dpqviupgwjruhhwu")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value The state of the Experiment
     */
    @JvmName("qgnmcsdcoltljotw")
    public fun enabledState(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("trhejxattowltgrl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Profile
     */
    @JvmName("lqxhwvuhropjmols")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Profile identifier associated with the Tenant and Partner
     */
    @JvmName("jtdajcbrihpncixk")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("xrisfqlvpalwnnrh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ijyyyrqeeacbawko")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dutpdqgaceaextmr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkExperimentProfileArgs = NetworkExperimentProfileArgs(
        enabledState = enabledState,
        location = location,
        name = name,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
